/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Concat
implements Function {
    public String getURI() {
        return ((Object)FN.CONCAT).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length == 0) {
            throw new ValueExprEvaluationException("CONCAT requires at least 1 argument, got " + args.length);
        }
        StringBuilder concatBuilder = new StringBuilder();
        String languageTag = null;
        boolean useLanguageTag = true;
        boolean useDatatype = true;
        for (Value arg : args) {
            Literal lit;
            if (arg instanceof Literal) {
                lit = (Literal)arg;
                if (useLanguageTag && lit.getLanguage() != null) {
                    if (languageTag == null) {
                        languageTag = lit.getLanguage();
                    } else if (!languageTag.equals(lit.getLanguage())) {
                        languageTag = null;
                        useLanguageTag = false;
                    }
                } else {
                    useLanguageTag = false;
                }
                if (lit.getDatatype() == null) {
                    useDatatype = false;
                } else if (!((Object)lit.getDatatype()).equals(XMLSchema.STRING)) {
                    throw new ValueExprEvaluationException("unexpected data type for concat operand: " + arg);
                }
            } else {
                throw new ValueExprEvaluationException("unexpected argument type for concat operator: " + arg);
            }
            concatBuilder.append(lit.getLabel());
        }
        Literal result = null;
        result = useDatatype ? valueFactory.createLiteral(concatBuilder.toString(), XMLSchema.STRING) : (useLanguageTag ? valueFactory.createLiteral(concatBuilder.toString(), languageTag) : valueFactory.createLiteral(concatBuilder.toString()));
        return result;
    }
}

