/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

public class FilterOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new FilterFinder(tupleExpr));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterRelocator
    extends QueryModelVisitorBase<RuntimeException> {
        protected Filter filter;
        protected final Set<String> filterVars;

        public FilterRelocator(Filter filter) {
            this.filter = filter;
            this.filterVars = VarNameCollector.process(filter.getCondition());
        }

        @Override
        protected void meetNode(QueryModelNode node) {
        }

        @Override
        public void meet(Join join) {
            if (join.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join.getLeftArg().visit(this);
            } else if (join.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join.getRightArg().visit(this);
            } else {
                this.relocate(this.filter, join);
            }
        }

        @Override
        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit(this);
            } else {
                this.relocate(this.filter, leftJoin);
            }
        }

        @Override
        public void meet(Union union) {
            union.getLeftArg().visit(this);
            ValueExpr conditionClone = this.filter.getCondition().clone();
            this.filter = new Filter();
            this.filter.setCondition(conditionClone);
            union.getRightArg().visit(this);
        }

        @Override
        public void meet(StatementPattern sp) {
            this.relocate(this.filter, sp);
        }

        @Override
        public void meet(Filter filter) {
            filter.getArg().visit(this);
        }

        @Override
        public void meet(Group group) {
            group.getArg().visit(this);
        }

        protected void relocate(Filter filter, TupleExpr newFilterArg) {
            if (filter.getArg() != newFilterArg) {
                if (filter.getParentNode() != null) {
                    filter.replaceWith(filter.getArg());
                }
                newFilterArg.replaceWith(filter);
                filter.setArg(newFilterArg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterFinder
    extends QueryModelVisitorBase<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public FilterFinder(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        @Override
        public void meet(Filter filter) {
            super.meet(filter);
            filter.getArg().visit(this.getFilterRelocator(filter));
        }

        protected FilterRelocator getFilterRelocator(Filter filter) {
            return new FilterRelocator(filter);
        }
    }
}

