/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTBasicGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTBlankNode;
import org.openrdf.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.openrdf.query.parser.sparql.ast.ASTCollection;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class BlankNodeVarProcessor
extends ASTVisitorBase {
    public static void process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            qc.jjtAccept(new BlankNodeToVarConverter(), null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e);
        }
    }

    private static class BlankNodeToVarConverter
    extends ASTVisitorBase {
        private int anonVarNo = 1;
        private Map<String, String> conversionMap = new HashMap<String, String>();
        private Set<String> usedBNodeIDs = new HashSet<String>();

        private BlankNodeToVarConverter() {
        }

        private String createAnonVarName() {
            return "-anon-" + this.anonVarNo++;
        }

        public Object visit(ASTBasicGraphPattern node, Object data) throws VisitorException {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            this.conversionMap.clear();
            return super.visit(node, data);
        }

        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            String bnodeID = node.getID();
            String varName = this.findVarName(bnodeID);
            if (varName == null) {
                varName = this.createAnonVarName();
                if (bnodeID != null) {
                    this.conversionMap.put(bnodeID, varName);
                }
            }
            ASTVar varNode = new ASTVar(48);
            varNode.setName(varName);
            varNode.setAnonymous(true);
            node.jjtReplaceWith(varNode);
            return super.visit(node, data);
        }

        private String findVarName(String bnodeID) throws VisitorException {
            if (bnodeID == null) {
                return null;
            }
            String varName = this.conversionMap.get(bnodeID);
            if (varName == null && this.usedBNodeIDs.contains(bnodeID)) {
                throw new VisitorException("BNodeID already used in another scope: " + bnodeID);
            }
            return varName;
        }

        public Object visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }

        public Object visit(ASTCollection node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }
    }
}

