/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.PatternStage;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryPlan;
import com.hp.hpl.jena.graph.query.SimpleTreeQueryPlan;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Set;

public class SimpleQueryHandler
implements QueryHandler {
    protected Graph graph;

    public SimpleQueryHandler(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Stage patternStage(Mapping map, ExpressionSet constraints, Triple[] t) {
        return new PatternStage(this.graph, map, constraints, t);
    }

    @Override
    public BindingQueryPlan prepareBindings(Query q, Node[] variables) {
        return new SimpleQueryPlan(this.graph, q, variables);
    }

    @Override
    public TreeQueryPlan prepareTree(Graph pattern) {
        return new SimpleTreeQueryPlan(this.graph, pattern);
    }

    @Override
    public ExtendedIterator<Node> objectsFor(Node s, Node p) {
        return SimpleQueryHandler.objectsFor(this.graph, s, p);
    }

    @Override
    public ExtendedIterator<Node> subjectsFor(Node p, Node o) {
        return SimpleQueryHandler.subjectsFor(this.graph, p, o);
    }

    @Override
    public ExtendedIterator<Node> predicatesFor(Node s, Node o) {
        return SimpleQueryHandler.predicatesFor(this.graph, s, o);
    }

    public static ExtendedIterator<Node> objectsFor(Graph g, Node s, Node p) {
        Set objects = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> it = g.find(s, p, Node.ANY);
        while (it.hasNext()) {
            objects.add(((Triple)it.next()).getObject());
        }
        return WrappedIterator.createNoRemove(objects.iterator());
    }

    public static ExtendedIterator<Node> subjectsFor(Graph g, Node p, Node o) {
        Set objects = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> it = g.find(Node.ANY, p, o);
        while (it.hasNext()) {
            objects.add(((Triple)it.next()).getSubject());
        }
        return WrappedIterator.createNoRemove(objects.iterator());
    }

    public static ExtendedIterator<Node> predicatesFor(Graph g, Node s, Node o) {
        Set predicates = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> it = g.find(s, Node.ANY, o);
        while (it.hasNext()) {
            predicates.add(((Triple)it.next()).getPredicate());
        }
        return WrappedIterator.createNoRemove(predicates.iterator());
    }

    @Override
    public boolean containsNode(Node n) {
        return this.graph.contains(n, Node.ANY, Node.ANY) || this.graph.contains(Node.ANY, n, Node.ANY) || this.graph.contains(Node.ANY, Node.ANY, n);
    }
}

