/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openjena.atlas.logging.Log;

public class BindingHashMap
extends BindingBase
implements BindingMap {
    Map<Var, Node> map = new HashMap<Var, Node>();

    public BindingHashMap(Binding parent) {
        super(parent);
    }

    public BindingHashMap() {
        super(BindingRoot.create());
    }

    protected void add1(Var var, Node node) {
        if (!Var.isAnonVar(var)) {
            this.map.put(var, node);
        }
    }

    @Override
    protected int size1() {
        return this.map.size();
    }

    @Override
    protected boolean isEmpty1() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<Var> vars1() {
        Iterator<Var> iter = this.map.keySet().iterator();
        return iter;
    }

    @Override
    public boolean contains1(Var var) {
        return this.map.containsKey((Object)var);
    }

    @Override
    public Node get1(Var var) {
        return this.map.get((Object)var);
    }

    @Override
    public final void add(Var var, Node node) {
        if (node == null) {
            Log.warn(this, "Binding.add: null value - ignored");
            return;
        }
        this.checkAdd(var, node);
        this.add1(var, node);
    }

    @Override
    public final void addAll(Binding other) {
        BindingUtils.addAll(this, other);
    }

    private void checkAdd(Var var, Node node) {
        if (!CHECKING) {
            return;
        }
        if (var == null) {
            throw new ARQInternalErrorException("check(" + (Object)((Object)var) + ", " + node + "): null var");
        }
        if (node == null) {
            throw new ARQInternalErrorException("check(" + (Object)((Object)var) + ", " + node + "): null node value");
        }
        if (UNIQUE_NAMES_CHECK && this.contains(var)) {
            throw new ARQInternalErrorException("Attempt to reassign '" + (Object)((Object)var) + "' from '" + FmtUtils.stringForNode(this.get(var)) + "' to '" + FmtUtils.stringForNode(node) + "'");
        }
        this.checkAdd1(var, node);
    }

    protected void checkAdd1(Var v, Node node) {
    }
}

