/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.arnx.jsonic.AppendableConverter;
import net.arnx.jsonic.ArrayConverter;
import net.arnx.jsonic.BigDecimalConverter;
import net.arnx.jsonic.BigIntegerConverter;
import net.arnx.jsonic.BooleanArrayFormatter;
import net.arnx.jsonic.BooleanConverter;
import net.arnx.jsonic.ByteArrayFormatter;
import net.arnx.jsonic.ByteConverter;
import net.arnx.jsonic.ByteFormatter;
import net.arnx.jsonic.CalendarConverter;
import net.arnx.jsonic.CalendarFormatter;
import net.arnx.jsonic.CharArrayFormatter;
import net.arnx.jsonic.CharSequenceConverter;
import net.arnx.jsonic.CharacterConverter;
import net.arnx.jsonic.CharacterDataFormatter;
import net.arnx.jsonic.CharsetConverter;
import net.arnx.jsonic.CharsetFormatter;
import net.arnx.jsonic.ClassConverter;
import net.arnx.jsonic.ClassFormatter;
import net.arnx.jsonic.CollectionConverter;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DOMDocumentFormatter;
import net.arnx.jsonic.DOMElementFormatter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.DateFormatter;
import net.arnx.jsonic.DoubleArrayFormatter;
import net.arnx.jsonic.DoubleConverter;
import net.arnx.jsonic.DynaBeanFormatter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.EnumFormatter;
import net.arnx.jsonic.EnumerationFormatter;
import net.arnx.jsonic.FileConverter;
import net.arnx.jsonic.FloatArrayFormatter;
import net.arnx.jsonic.FloatConverter;
import net.arnx.jsonic.FloatFormatter;
import net.arnx.jsonic.FormatConverter;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.InetAddressConverter;
import net.arnx.jsonic.InetAddressFormatter;
import net.arnx.jsonic.IntArrayFormatter;
import net.arnx.jsonic.IntegerConverter;
import net.arnx.jsonic.IterableFormatter;
import net.arnx.jsonic.IteratorFormatter;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.ListFormatter;
import net.arnx.jsonic.LocaleConverter;
import net.arnx.jsonic.LocaleFormatter;
import net.arnx.jsonic.LongArrayFormatter;
import net.arnx.jsonic.LongConverter;
import net.arnx.jsonic.MapConverter;
import net.arnx.jsonic.MapFormatter;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.NullConverter;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.NumberFormatter;
import net.arnx.jsonic.ObjectArrayFormatter;
import net.arnx.jsonic.ObjectConverter;
import net.arnx.jsonic.ObjectFormatter;
import net.arnx.jsonic.PatternConverter;
import net.arnx.jsonic.PlainConverter;
import net.arnx.jsonic.PlainFormatter;
import net.arnx.jsonic.PropertiesConverter;
import net.arnx.jsonic.SQLArrayFormatter;
import net.arnx.jsonic.SerializableConverter;
import net.arnx.jsonic.SerializableFormatter;
import net.arnx.jsonic.ShortArrayFormatter;
import net.arnx.jsonic.ShortConverter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.StringSerializableConverter;
import net.arnx.jsonic.StructFormmatter;
import net.arnx.jsonic.TimeZoneConverter;
import net.arnx.jsonic.TimeZoneFormatter;
import net.arnx.jsonic.URIConverter;
import net.arnx.jsonic.URLConverter;
import net.arnx.jsonic.UUIDConverter;
import net.arnx.jsonic.io.AppendableOutputSource;
import net.arnx.jsonic.io.CharSequenceInputSource;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.io.ReaderInputSource;
import net.arnx.jsonic.io.StringBuilderOutputSource;
import net.arnx.jsonic.io.WriterOutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;
import net.arnx.jsonic.util.PropertyInfo;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    public static volatile Class<? extends JSON> prototype = JSON.class;
    private static final Map<Class<?>, Formatter> FORMAT_MAP = new HashMap(50);
    private static final Map<Class<?>, Converter> CONVERT_MAP = new HashMap(50);
    private Object contextObject;
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private boolean prettyPrint = false;
    private int maxDepth = 32;
    private boolean suppressNull = false;
    private Mode mode = Mode.TRADITIONAL;
    private String dateFormat;
    private String numberFormat;
    private NamingStyle propertyStyle;
    private NamingStyle enumStyle;

    static JSON newInstance() {
        JSON instance = null;
        try {
            instance = prototype.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return instance;
    }

    public static String encode(Object source) throws JSONException {
        return JSON.encode(source, false);
    }

    public static String encode(Object source, boolean prettyPrint) throws JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        return json.format(source);
    }

    public static void encode(Object source, OutputStream out) throws IOException, JSONException {
        JSON.newInstance().format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, OutputStream out, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, Appendable appendable) throws IOException, JSONException {
        JSON.newInstance().format(source, appendable);
    }

    public static void encode(Object source, Appendable appendable, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, appendable);
    }

    public static String escapeScript(Object source) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        return json.format(source);
    }

    public static void escapeScript(Object source, OutputStream out) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, out);
    }

    public static void escapeScript(Object source, Appendable appendable) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, appendable);
    }

    public static <T> T decode(String source) throws JSONException {
        return JSON.newInstance().parse(source);
    }

    public static <T> T decode(String source, Class<? extends T> cls) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, cls);
    }

    public static <T> T decode(String source, Type type) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, type);
    }

    public static <T> T decode(InputStream in) throws IOException, JSONException {
        return JSON.newInstance().parse(in);
    }

    public static <T> T decode(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(in, cls);
    }

    public static <T> T decode(InputStream in, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(in, type);
    }

    public static <T> T decode(Reader reader) throws IOException, JSONException {
        return JSON.newInstance().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, cls);
    }

    public static <T> T decode(Reader reader, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, type);
    }

    public static void validate(CharSequence cs) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(cs);
    }

    public static void validate(InputStream in) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(in);
    }

    public static void validate(Reader reader) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(reader);
    }

    public JSON() {
    }

    public JSON(int maxDepth) {
        this.setMaxDepth(maxDepth);
    }

    public JSON(Mode mode) {
        this.setMode(mode);
    }

    public void setContext(Object value) {
        this.contextObject = value;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    public void setPrettyPrint(boolean value) {
        this.prettyPrint = value;
    }

    public void setMaxDepth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = value;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSuppressNull(boolean value) {
        this.suppressNull = value;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public void setNumberFormat(String format) {
        this.numberFormat = format;
    }

    public void setPropertyStyle(NamingStyle style) {
        this.propertyStyle = style;
    }

    public void setEnumStyle(NamingStyle style) {
        this.enumStyle = style;
    }

    public String format(Object source) {
        String text = null;
        try {
            text = this.format(source, new StringBuilder(1000)).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    public OutputStream format(Object source, OutputStream out) throws IOException {
        this.format(source, new BufferedWriter(new OutputStreamWriter(out, "UTF-8")));
        return out;
    }

    public Appendable format(Object source, Appendable ap) throws IOException {
        Context context = new Context();
        OutputSource fs = ap instanceof Writer ? new WriterOutputSource((Writer)ap) : (ap instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)ap) : new AppendableOutputSource(ap));
        context.enter(Character.valueOf('$'));
        source = this.preformatInternal(context, source);
        this.formatInternal(context, source, fs);
        context.exit();
        fs.flush();
        return ap;
    }

    protected Object preformat(Context context, Object value) throws Exception {
        return value;
    }

    final Object preformatInternal(Context context, Object value) {
        if (value == null) {
            return null;
        }
        if (context.getLevel() > context.getMaxDepth()) {
            return null;
        }
        if (this.getClass() != JSON.class) {
            try {
                return this.preformat(context, value);
            }
            catch (Exception e) {
                throw new JSONException(this.getMessage("json.format.ConversionError", value, context), 150, e);
            }
        }
        return value;
    }

    final Formatter formatInternal(Context context, Object src, OutputSource ap) throws IOException {
        boolean isStruct;
        Object o = src;
        Formatter f = null;
        if (o == null) {
            f = NullFormatter.INSTANCE;
        } else {
            JSONHint hint = context.getHint();
            if (hint != null) {
                if (context.skipHint) {
                    context.skipHint = false;
                } else if (hint.serialized()) {
                    f = PlainFormatter.INSTANCE;
                } else if (String.class.equals(hint.type())) {
                    f = StringFormatter.INSTANCE;
                } else if (Serializable.class.equals(hint.type())) {
                    f = SerializableFormatter.INSTANCE;
                }
            }
        }
        if (f == null) {
            f = FORMAT_MAP.get(o.getClass());
        }
        if (f == null) {
            if (context.hasMemberCache(o.getClass())) {
                f = ObjectFormatter.INSTANCE;
            } else if (o instanceof Map) {
                f = MapFormatter.INSTANCE;
            } else if (o instanceof Iterable) {
                f = o instanceof RandomAccess && o instanceof List ? ListFormatter.INSTANCE : IterableFormatter.INSTANCE;
            } else if (o instanceof Object[]) {
                f = ObjectArrayFormatter.INSTANCE;
            } else if (o instanceof Enum) {
                f = EnumFormatter.INSTANCE;
            } else if (o instanceof CharSequence) {
                f = StringFormatter.INSTANCE;
            } else if (o instanceof Date) {
                f = DateFormatter.INSTANCE;
            } else if (o instanceof Calendar) {
                f = CalendarFormatter.INSTANCE;
            } else if (o instanceof Number) {
                f = NumberFormatter.INSTANCE;
            } else if (o instanceof Iterator) {
                f = IteratorFormatter.INSTANCE;
            } else if (o instanceof Enumeration) {
                f = EnumerationFormatter.INSTANCE;
            } else if (o instanceof Type || o instanceof Member || o instanceof File) {
                f = StringFormatter.INSTANCE;
            } else if (o instanceof TimeZone) {
                f = TimeZoneFormatter.INSTANCE;
            } else if (o instanceof Charset) {
                f = CharsetFormatter.INSTANCE;
            } else if (o instanceof Array) {
                f = SQLArrayFormatter.INSTANCE;
            } else if (o instanceof Struct) {
                f = StructFormmatter.INSTANCE;
            } else if (o instanceof Node) {
                if (o instanceof CharacterData && !(o instanceof Comment)) {
                    f = CharacterDataFormatter.INSTANCE;
                } else if (o instanceof Document) {
                    f = DOMDocumentFormatter.INSTANCE;
                } else if (o instanceof Element) {
                    f = DOMElementFormatter.INSTANCE;
                }
            } else {
                f = JSON.isAssignableFrom(ClassUtil.findClass("java.sql.RowId"), o.getClass()) ? SerializableFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("java.net.InetAddress"), o.getClass()) ? InetAddressFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("org.apache.commons.beanutils.DynaBean"), o.getClass()) ? DynaBeanFormatter.INSTANCE : ObjectFormatter.INSTANCE));
            }
        }
        try {
            isStruct = f.format(this, context, src, o, ap);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException(this.getMessage("json.format.ConversionError", src instanceof CharSequence ? "\"" + src + "\"" : src, context), 100, e);
        }
        if (!isStruct && context.getLevel() == 0 && context.getMode() != Mode.SCRIPT) {
            throw new JSONException(this.getMessage("json.format.IllegalRootTypeError", new Object[0]), 100);
        }
        return f;
    }

    public <T> T parse(CharSequence cs) throws JSONException {
        Object value = null;
        try {
            value = this.parseInternal(new Context(), new CharSequenceInputSource(cs));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)value;
    }

    public <T> T parse(CharSequence s, Class<? extends T> cls) throws JSONException {
        return this.parse(s, (Type)cls);
    }

    public <T> T parse(CharSequence s, Type type) throws JSONException {
        T value = null;
        try {
            Context context = new Context();
            value = this.convert(context, this.parseInternal(context, new CharSequenceInputSource(s)), type);
        }
        catch (IOException e) {
            // empty catch block
        }
        return value;
    }

    public <T> T parse(InputStream in) throws IOException, JSONException {
        return (T)this.parseInternal(new Context(), new ReaderInputSource(in));
    }

    public <T> T parse(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(in, (Type)cls);
    }

    public <T> T parse(InputStream in, Type type) throws IOException, JSONException {
        Context context = new Context();
        return this.convert(context, this.parseInternal(context, new ReaderInputSource(in)), type);
    }

    public <T> T parse(Reader reader) throws IOException, JSONException {
        return (T)this.parseInternal(new Context(), new ReaderInputSource(reader));
    }

    public <T> T parse(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(reader, (Type)cls);
    }

    public <T> T parse(Reader reader, Type type) throws IOException, JSONException {
        Context context = new Context();
        return this.convert(context, this.parseInternal(context, new ReaderInputSource(reader)), type);
    }

    private Object parseInternal(Context context, InputSource s) throws IOException, JSONException {
        boolean isEmpty = true;
        Map<Object, Object> o = null;
        int n = -1;
        block7: while ((n = s.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\ufeff': {
                    continue block7;
                }
                case '{': {
                    if (isEmpty) {
                        s.back();
                        o = this.parseObject(context, s, 1);
                        isEmpty = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '[': {
                    if (isEmpty) {
                        s.back();
                        o = this.parseArray(context, s, 1);
                        isEmpty = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '#': 
                case '/': {
                    if (context.getMode() == Mode.TRADITIONAL || context.getMode() == Mode.SCRIPT && c == '/') {
                        s.back();
                        this.skipComment(context, s);
                        continue block7;
                    }
                }
                case '\"': 
                case '\'': {
                    if (context.getMode() != Mode.SCRIPT) break;
                    if (isEmpty) {
                        s.back();
                        o = this.parseString(context, s, 1);
                        isEmpty = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
            }
            if (context.getMode() == Mode.SCRIPT) {
                if (isEmpty) {
                    s.back();
                    o = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, s, 1) : this.parseLiteral(context, s, 1, false);
                    isEmpty = false;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
            }
            if (context.getMode() == Mode.TRADITIONAL && isEmpty) {
                s.back();
                o = this.parseObject(context, s, 1);
                isEmpty = false;
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
        }
        if (isEmpty) {
            if (context.getMode() == Mode.TRADITIONAL) {
                o = new LinkedHashMap();
            } else {
                throw this.createParseException(this.getMessage("json.parse.EmptyInputError", new Object[0]), s);
            }
        }
        return o;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<Object, Object> parseObject(Context context, InputSource s, int level) throws IOException, JSONException {
        int point = 0;
        LinkedHashMap<Object, Object> map = level <= context.getMaxDepth() ? new LinkedHashMap<Object, Object>() : null;
        Object key = null;
        int start = 0;
        int n = -1;
        block12: while ((n = s.next()) != -1) {
            Object value;
            char c = (char)n;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (context.getMode() != Mode.TRADITIONAL || point != 5) continue block12;
                    point = 6;
                    continue block12;
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block12;
                }
                case '{': {
                    if (point == 0) {
                        start = 123;
                        point = 1;
                        continue block12;
                    }
                    if (point != 2 && point != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseObject(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        map.put(key, value);
                    }
                    point = 5;
                    continue block12;
                }
                case ':': {
                    if (point != 2) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    point = 3;
                    continue block12;
                }
                case ',': {
                    if (point == 5 || point == 6 || context.getMode() == Mode.TRADITIONAL && point == 3) {
                        if (point == 3 && level < context.getMaxDepth() && !context.isSuppressNull()) {
                            map.put(key, null);
                        }
                        point = 1;
                        continue block12;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '}': {
                    if (start == 123 && (point == 1 || point == 5 || point == 6 || context.getMode() == Mode.TRADITIONAL && point == 3)) {
                        if (point != 3 || level >= context.getMaxDepth() || context.isSuppressNull()) break block12;
                        map.put(key, null);
                        break block12;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '[': {
                    if (point != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseArray(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        map.put(key, value);
                    }
                    point = 5;
                    continue block12;
                }
                case '\'': {
                    if (context.getMode() == Mode.STRICT) break;
                }
                case '\"': {
                    if (point == 0) {
                        s.back();
                        point = 1;
                        continue block12;
                    }
                    if (point == 1 || point == 6) {
                        s.back();
                        key = this.parseString(context, s, level + 1);
                        point = 2;
                        continue block12;
                    }
                    if (point != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseString(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        map.put(key, value);
                    }
                    point = 5;
                    continue block12;
                }
                case '#': 
                case '/': {
                    if (context.getMode() != Mode.TRADITIONAL && (context.getMode() != Mode.SCRIPT || c != '/')) break;
                    s.back();
                    this.skipComment(context, s);
                    if (point != 5) continue block12;
                    point = 6;
                    continue block12;
                }
            }
            if (point == 0) {
                s.back();
                point = 1;
                continue;
            }
            if (point == 1 || point == 6) {
                s.back();
                key = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, s, level + 1) : this.parseLiteral(context, s, level + 1, context.getMode() != Mode.STRICT);
                point = 2;
                continue;
            }
            if (point != 3) {
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
            }
            s.back();
            Object object = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, s, level + 1) : (value = this.parseLiteral(context, s, level + 1, context.getMode() == Mode.TRADITIONAL));
            if (!(level >= context.getMaxDepth() || value == null && context.isSuppressNull())) {
                map.put(key, value);
            }
            point = 5;
        }
        if (n == -1) {
            if (point == 3 || point == 4) {
                if (level < context.getMaxDepth() && !context.isSuppressNull()) {
                    map.put(key, null);
                }
            } else if (point == 2) {
                throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), s);
            }
        }
        if (n == -1) {
            if (start == 0) return map;
            throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), s);
        }
        if (n == 125) return map;
        throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), s);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Object> parseArray(Context context, InputSource s, int level) throws IOException, JSONException {
        int point = 0;
        ArrayList<Object> list = level <= context.getMaxDepth() ? new ArrayList<Object>() : null;
        int n = -1;
        block11: while ((n = s.next()) != -1) {
            Object value;
            char c = (char)n;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (context.getMode() != Mode.TRADITIONAL || point != 2) continue block11;
                    point = 3;
                    continue block11;
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block11;
                }
                case '[': {
                    if (point == 0) {
                        point = 1;
                        continue block11;
                    }
                    if (point != 1 && point != 3 && point != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseArray(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        list.add(value);
                    }
                    point = 2;
                    continue block11;
                }
                case ',': {
                    if (context.getMode() == Mode.TRADITIONAL && (point == 1 || point == 4)) {
                        if (level >= context.getMaxDepth()) continue block11;
                        list.add(null);
                        continue block11;
                    }
                    if (point != 2 && point != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    point = 4;
                    continue block11;
                }
                case ']': {
                    if (point == true || point == 2 || point == 3) break block11;
                    if (context.getMode() == Mode.TRADITIONAL && point == 4) {
                        if (level >= context.getMaxDepth()) break block11;
                        list.add(null);
                        break block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '{': {
                    if (point != 1 && point != 3 && point != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseObject(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        list.add(value);
                    }
                    point = 2;
                    continue block11;
                }
                case '\'': {
                    if (context.getMode() == Mode.STRICT) break;
                }
                case '\"': {
                    if (point != 1 && point != 3 && point != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    s.back();
                    value = this.parseString(context, s, level + 1);
                    if (level < context.getMaxDepth()) {
                        list.add(value);
                    }
                    point = 2;
                    continue block11;
                }
                case '#': 
                case '/': {
                    if (context.getMode() != Mode.TRADITIONAL && (context.getMode() != Mode.SCRIPT || c != '/')) break;
                    s.back();
                    this.skipComment(context, s);
                    if (point != 2) continue block11;
                    point = 3;
                    continue block11;
                }
            }
            if (point != 1 && point != 3 && point != 4) {
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
            }
            s.back();
            Object object = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, s, level + 1) : (value = this.parseLiteral(context, s, level + 1, context.getMode() == Mode.TRADITIONAL));
            if (level < context.getMaxDepth()) {
                list.add(value);
            }
            point = 2;
        }
        if (n != 93) {
            throw this.createParseException(this.getMessage("json.parse.ArrayNotClosedError", new Object[0]), s);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseString(Context context, InputSource s, int level) throws IOException, JSONException {
        int n;
        boolean point = false;
        StringBuilder sb = level <= context.getMaxDepth() ? context.getCachedBuffer() : null;
        int start = 0;
        int n2 = -1;
        block6: while ((n = s.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\ufeff': {
                    continue block6;
                }
                case '\\': {
                    if (!point) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    if (context.getMode() != Mode.TRADITIONAL || start == 34) {
                        s.back();
                        c = this.parseEscape(s);
                        if (sb == null) continue block6;
                        sb.append(c);
                        continue block6;
                    }
                    if (sb == null) continue block6;
                    sb.append(c);
                    continue block6;
                }
                case '\'': {
                    if (context.getMode() == Mode.STRICT) break;
                }
                case '\"': {
                    if (!point) {
                        start = c;
                        point = true;
                        continue block6;
                    }
                    if (!point) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                    if (start == c) break block6;
                    if (sb == null) continue block6;
                    sb.append(c);
                    continue block6;
                }
            }
            if (point && (context.getMode() != Mode.STRICT || c >= ' ')) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
        }
        if (n != start) {
            throw this.createParseException(this.getMessage("json.parse.StringNotClosedError", new Object[0]), s);
        }
        if (sb == null) return null;
        String string = sb.toString();
        return string;
    }

    private Object parseLiteral(Context context, InputSource s, int level, boolean any) throws IOException, JSONException {
        String str;
        boolean point = false;
        StringBuilder sb = context.getCachedBuffer();
        int n = -1;
        while ((n = s.next()) != -1) {
            char c = (char)n;
            if (c == '\ufeff') continue;
            if (c == '\\') {
                s.back();
                c = this.parseEscape(s);
            }
            if (!point && Character.isJavaIdentifierStart(c)) {
                sb.append(c);
                point = true;
                continue;
            }
            if (point && (Character.isJavaIdentifierPart(c) || c == '.')) {
                sb.append(c);
                continue;
            }
            s.back();
            break;
        }
        if ("null".equals(str = sb.toString())) {
            return null;
        }
        if ("true".equals(str)) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        if (!any) {
            throw this.createParseException(this.getMessage("json.parse.UnrecognizedLiteral", str), s);
        }
        return str;
    }

    private Number parseNumber(Context context, InputSource s, int level) throws IOException, JSONException {
        int point = 0;
        StringBuilder sb = level <= context.getMaxDepth() ? context.getCachedBuffer() : null;
        int n = -1;
        block7: while ((n = s.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '+': {
                    if (point == 7) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        point = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '-': {
                    if (point == 0) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        point = 1;
                        continue block7;
                    }
                    if (point == 7) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        point = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '.': {
                    if (point == 2 || point == 3) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        point = 4;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case 'E': 
                case 'e': {
                    if (point == 2 || point == 3 || point == 5 || point == 6) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        point = 7;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
            }
            if (c >= '0' && c <= '9') {
                if (point == 0 || point == 1) {
                    if (sb != null) {
                        sb.append(c);
                    }
                    point = c == '0' ? 3 : 2;
                    continue;
                }
                if (point == 2 || point == 5 || point == 9) {
                    if (sb == null) continue;
                    sb.append(c);
                    continue;
                }
                if (point == 4) {
                    if (sb != null) {
                        sb.append(c);
                    }
                    point = 5;
                    continue;
                }
                if (point == 7 || point == 8) {
                    if (sb != null) {
                        sb.append(c);
                    }
                    point = 9;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
            }
            if (point == 2 || point == 3 || point == 5 || point == 6 || point == 9) {
                s.back();
                break;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
        }
        return sb != null ? new BigDecimal(sb.toString()) : null;
    }

    private char parseEscape(InputSource s) throws IOException, JSONException {
        int point = 0;
        int escape = 0;
        int n = -1;
        block8: while ((n = s.next()) != -1) {
            int hex;
            char c = (char)n;
            if (c == '\ufeff') continue;
            if (point == 0) {
                if (c == '\\') {
                    point = 1;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
            }
            if (point == 1) {
                switch (c) {
                    case 'b': {
                        escape = 8;
                        break;
                    }
                    case 'f': {
                        escape = 12;
                        break;
                    }
                    case 'n': {
                        escape = 10;
                        break;
                    }
                    case 'r': {
                        escape = 13;
                        break;
                    }
                    case 't': {
                        escape = 9;
                        break;
                    }
                    case 'u': {
                        point = 2;
                        continue block8;
                    }
                    default: {
                        escape = c;
                        break;
                    }
                }
                break;
            }
            int n2 = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (hex = c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
            if (hex != -1) {
                escape = (char)(escape | hex << (5 - point) * 4);
                if (point == 5) break;
                ++point;
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.IllegalUnicodeEscape", Character.valueOf(c)), s);
        }
        return (char)escape;
    }

    private void skipComment(Context context, InputSource s) throws IOException, JSONException {
        int point = 0;
        int n = -1;
        block7: while ((n = s.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '/': {
                    if (point == 0) {
                        point = 1;
                        continue block7;
                    }
                    if (point == 1) {
                        point = 4;
                        continue block7;
                    }
                    if (point == 3) break block7;
                    if (point == 2 || point == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '*': {
                    if (point == 1) {
                        point = 2;
                        continue block7;
                    }
                    if (point == 2) {
                        point = 3;
                        continue block7;
                    }
                    if (point == 3 || point == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '\n': 
                case '\r': {
                    if (point == 2 || point == 3) {
                        point = 2;
                        continue block7;
                    }
                    if (point == 4) break block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
                case '#': {
                    if (context.getMode() == Mode.TRADITIONAL) {
                        if (point == 0) {
                            point = 4;
                            continue block7;
                        }
                        if (point == 3) {
                            point = 2;
                            continue block7;
                        }
                        if (point == 2 || point == 4) continue block7;
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                    }
                }
                default: {
                    if (point == 3) {
                        point = 2;
                        continue block7;
                    }
                    if (point == 2 || point == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), s);
                }
            }
        }
    }

    JSONException createParseException(String message, InputSource s) {
        return new JSONException("" + s.getLineNumber() + ": " + message + "\n" + s.toString() + " <- ?", 200, s.getLineNumber(), s.getColumnNumber(), s.getOffset());
    }

    String getMessage(String id, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
        return MessageFormat.format(bundle.getString(id), args);
    }

    public Object convert(Object value, Type type) throws JSONException {
        return this.convert(new Context(), value, type);
    }

    private <T> T convert(Context context, Object value, Type type) throws JSONException {
        Class<?> cls = ClassUtil.getRawType(type);
        T result = null;
        try {
            context.enter(Character.valueOf('$'));
            result = (T)this.postparse(context, value, cls, type);
            context.exit();
        }
        catch (Exception e) {
            String text;
            if (value instanceof CharSequence) {
                text = "\"" + value + "\"";
            } else {
                try {
                    text = value.toString();
                }
                catch (Exception e2) {
                    text = value.getClass().toString();
                }
            }
            throw new JSONException(this.getMessage("json.parse.ConversionError", text, type, context), 250, e);
        }
        return result;
    }

    protected <T> T postparse(Context context, Object value, Class<? extends T> cls, Type type) throws Exception {
        Converter c = null;
        if (value == null) {
            if (!cls.isPrimitive()) {
                c = NullConverter.INSTANCE;
            }
        } else {
            JSONHint hint = context.getHint();
            if (hint != null) {
                if (context.skipHint) {
                    context.skipHint = false;
                } else if (hint.serialized()) {
                    c = FormatConverter.INSTANCE;
                } else if (Serializable.class.equals(hint.type())) {
                    c = SerializableConverter.INSTANCE;
                } else if (String.class.equals(hint.type())) {
                    c = StringSerializableConverter.INSTANCE;
                }
            }
        }
        if (c == null) {
            c = value != null && cls.equals(type) && cls.isAssignableFrom(value.getClass()) ? PlainConverter.INSTANCE : CONVERT_MAP.get(cls);
        }
        if (c == null) {
            c = context.hasMemberCache(cls) ? ObjectConverter.INSTANCE : (Properties.class.isAssignableFrom(cls) ? PropertiesConverter.INSTANCE : (Map.class.isAssignableFrom(cls) ? MapConverter.INSTANCE : (Collection.class.isAssignableFrom(cls) ? CollectionConverter.INSTANCE : (cls.isArray() ? ArrayConverter.INSTANCE : (cls.isEnum() ? EnumConverter.INSTANCE : (Date.class.isAssignableFrom(cls) ? DateConverter.INSTANCE : (Calendar.class.isAssignableFrom(cls) ? CalendarConverter.INSTANCE : (CharSequence.class.isAssignableFrom(cls) ? CharSequenceConverter.INSTANCE : (Appendable.class.isAssignableFrom(cls) ? AppendableConverter.INSTANCE : (cls.equals(ClassUtil.findClass("java.net.InetAddress")) ? InetAddressConverter.INSTANCE : (Array.class.isAssignableFrom(cls) || Struct.class.isAssignableFrom(cls) ? NullConverter.INSTANCE : ObjectConverter.INSTANCE)))))))))));
        }
        if (c != null) {
            return (T)c.convert(this, context, value, cls, type);
        }
        throw new UnsupportedOperationException();
    }

    protected String normalize(String name) {
        return name;
    }

    protected boolean ignore(Context context, Class<?> target, Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected <T> T create(Context context, Class<? extends T> c) throws Exception {
        Serializable instance = null;
        JSONHint hint = context.getHint();
        if (hint != null && hint.type() != Object.class) {
            c = hint.type().asSubclass(c);
        }
        if (c.isInterface()) {
            if (SortedMap.class.equals(c)) {
                instance = new TreeMap();
            } else if (Map.class.equals(c)) {
                instance = new LinkedHashMap();
            } else if (SortedSet.class.equals(c)) {
                instance = new TreeSet();
            } else if (Set.class.equals(c)) {
                instance = new LinkedHashSet();
            } else if (List.class.equals(c)) {
                instance = new ArrayList();
            } else if (Collection.class.equals(c)) {
                instance = new ArrayList();
            } else if (Appendable.class.equals(c)) {
                instance = new StringBuilder();
            }
        } else if (Modifier.isAbstract(c.getModifiers())) {
            if (Calendar.class.equals(c)) {
                instance = Calendar.getInstance();
            }
        } else if ((c.isMemberClass() || c.isAnonymousClass()) && !Modifier.isStatic(c.getModifiers())) {
            Class<?> eClass = c.getEnclosingClass();
            Constructor<T> con = c.getDeclaredConstructor(eClass);
            con.setAccessible(true);
            instance = context.contextObject != null && eClass.isAssignableFrom(context.contextObject.getClass()) ? con.newInstance(context.contextObject) : con.newInstance(new Object[]{null});
        } else {
            Constructor<T> con;
            if (Date.class.isAssignableFrom(c)) {
                try {
                    con = c.getDeclaredConstructor(Long.TYPE);
                    con.setAccessible(true);
                    instance = con.newInstance(0L);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (instance == null) {
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                instance = con.newInstance(new Object[0]);
            }
        }
        return c.cast(instance);
    }

    private static boolean isAssignableFrom(Class<?> target, Class<?> cls) {
        return target != null && target.isAssignableFrom(cls);
    }

    static {
        FORMAT_MAP.put(Boolean.TYPE, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.TYPE, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.TYPE, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(boolean[].class, BooleanArrayFormatter.INSTANCE);
        FORMAT_MAP.put(char[].class, CharArrayFormatter.INSTANCE);
        FORMAT_MAP.put(byte[].class, ByteArrayFormatter.INSTANCE);
        FORMAT_MAP.put(short[].class, ShortArrayFormatter.INSTANCE);
        FORMAT_MAP.put(int[].class, IntArrayFormatter.INSTANCE);
        FORMAT_MAP.put(long[].class, LongArrayFormatter.INSTANCE);
        FORMAT_MAP.put(float[].class, FloatArrayFormatter.INSTANCE);
        FORMAT_MAP.put(double[].class, DoubleArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Object[].class, ObjectArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Boolean.class, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.class, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(BigInteger.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(BigDecimal.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(String.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(java.sql.Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Time.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Timestamp.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(URI.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(URL.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(UUID.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Pattern.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Class.class, ClassFormatter.INSTANCE);
        FORMAT_MAP.put(Locale.class, LocaleFormatter.INSTANCE);
        FORMAT_MAP.put(ArrayList.class, ListFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedList.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(TreeSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(IdentityHashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(Properties.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(TreeMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashMap.class, MapFormatter.INSTANCE);
        CONVERT_MAP.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.TYPE, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.TYPE, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.TYPE, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.TYPE, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.TYPE, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.TYPE, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.TYPE, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(boolean[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(char[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(byte[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(short[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(int[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(long[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(float[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(double[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Object[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Boolean.class, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.class, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.class, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.class, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.class, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.class, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.class, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.class, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(BigInteger.class, BigIntegerConverter.INSTANCE);
        CONVERT_MAP.put(BigDecimal.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Number.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Pattern.class, PatternConverter.INSTANCE);
        CONVERT_MAP.put(TimeZone.class, TimeZoneConverter.INSTANCE);
        CONVERT_MAP.put(Locale.class, LocaleConverter.INSTANCE);
        CONVERT_MAP.put(File.class, FileConverter.INSTANCE);
        CONVERT_MAP.put(URL.class, URLConverter.INSTANCE);
        CONVERT_MAP.put(URI.class, URIConverter.INSTANCE);
        CONVERT_MAP.put(UUID.class, UUIDConverter.INSTANCE);
        CONVERT_MAP.put(Charset.class, CharsetConverter.INSTANCE);
        CONVERT_MAP.put(Class.class, ClassConverter.INSTANCE);
        CONVERT_MAP.put(Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(java.sql.Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Time.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Timestamp.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Calendar.class, CalendarConverter.INSTANCE);
        CONVERT_MAP.put(Collection.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Set.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(List.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(SortedSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(HashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(TreeSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Map.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(SortedMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(HashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(IdentityHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(TreeMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(Properties.class, PropertiesConverter.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Context {
        private final Locale locale;
        private final TimeZone timeZone;
        private final Object contextObject;
        private final int maxDepth;
        private final boolean prettyPrint;
        private final boolean suppressNull;
        private final Mode mode;
        private final String numberFormat;
        private final String dateFormat;
        private final NamingStyle propertyStyle;
        private final NamingStyle enumStyle;
        private Object[] path;
        private int level = -1;
        private Map<Class<?>, Object> memberCache;
        private Map<String, DateFormat> dateFormatCache;
        private Map<String, NumberFormat> numberFormatCache;
        private StringBuilder builderCache;
        boolean skipHint = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context() {
            JSON jSON2 = JSON.this;
            synchronized (jSON2) {
                this.locale = JSON.this.locale;
                this.timeZone = JSON.this.timeZone;
                this.contextObject = JSON.this.contextObject;
                this.maxDepth = JSON.this.maxDepth;
                this.prettyPrint = JSON.this.prettyPrint;
                this.suppressNull = JSON.this.suppressNull;
                this.mode = JSON.this.mode;
                this.numberFormat = JSON.this.numberFormat;
                this.dateFormat = JSON.this.dateFormat;
                this.propertyStyle = JSON.this.propertyStyle;
                this.enumStyle = JSON.this.enumStyle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Context context) {
            Context context2 = context;
            synchronized (context2) {
                this.locale = context.locale;
                this.timeZone = context.timeZone;
                this.contextObject = context.contextObject;
                this.maxDepth = context.maxDepth;
                this.prettyPrint = context.prettyPrint;
                this.suppressNull = context.suppressNull;
                this.mode = context.mode;
                this.numberFormat = context.numberFormat;
                this.dateFormat = context.dateFormat;
                this.propertyStyle = context.propertyStyle;
                this.enumStyle = context.enumStyle;
                this.level = context.level;
                this.path = (Object[])context.path.clone();
            }
        }

        public StringBuilder getCachedBuffer() {
            if (this.builderCache == null) {
                this.builderCache = new StringBuilder();
            } else {
                this.builderCache.setLength(0);
            }
            return this.builderCache;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public boolean isSuppressNull() {
            return this.suppressNull;
        }

        public Mode getMode() {
            return this.mode;
        }

        public NamingStyle getPropertyCaseStyle() {
            return this.propertyStyle;
        }

        public NamingStyle getEnumCaseStyle() {
            return this.enumStyle;
        }

        public int getLevel() {
            return this.level;
        }

        public Object getKey() {
            return this.path[this.level * 2];
        }

        public Object getKey(int level) {
            if (level < 0) {
                level = this.getLevel() + level;
            }
            return this.path[level * 2];
        }

        public JSONHint getHint() {
            return (JSONHint)this.path[this.level * 2 + 1];
        }

        public <T> T convert(Object key, Object value, Class<? extends T> c) throws Exception {
            this.enter(key);
            T o = JSON.this.postparse(this, value, c, c);
            this.exit();
            return (T)(c.isPrimitive() ? PlainConverter.getDefaultValue(c).getClass() : c).cast(o);
        }

        public Object convert(Object key, Object value, Type t) throws Exception {
            Class<?> c = ClassUtil.getRawType(t);
            this.enter(key);
            Object o = JSON.this.postparse(this, value, c, t);
            this.exit();
            return (c.isPrimitive() ? PlainConverter.getDefaultValue(c).getClass() : c).cast(o);
        }

        void enter(Object key, JSONHint hint) {
            ++this.level;
            if (this.path == null) {
                this.path = new Object[8];
            }
            if (this.path.length < this.level * 2 + 2) {
                Object[] newPath = new Object[Math.max(this.path.length * 2, this.level * 2 + 2)];
                System.arraycopy(this.path, 0, newPath, 0, this.path.length);
                this.path = newPath;
            }
            this.path[this.level * 2] = key;
            this.path[this.level * 2 + 1] = hint;
        }

        void enter(Object key) {
            this.enter(key, (JSONHint)(this.level != -1 ? this.path[this.level * 2 + 1] : null));
        }

        void exit() {
            --this.level;
        }

        boolean hasMemberCache(Class<?> c) {
            return this.memberCache != null && this.memberCache.containsKey(c);
        }

        List<PropertyInfo> getGetProperties(Class<?> c) {
            ArrayList<PropertyInfo> props;
            if (this.memberCache == null) {
                this.memberCache = new HashMap();
            }
            if ((props = (ArrayList<PropertyInfo>)this.memberCache.get(c)) == null) {
                props = new ArrayList<PropertyInfo>();
                for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
                    if (prop.isStatic() || !prop.isReadable() || JSON.this.ignore(this, c, prop.getReadMember())) continue;
                    String name = null;
                    int order = -1;
                    JSONHint hint = prop.getReadAnnotation(JSONHint.class);
                    if (hint != null) {
                        if (hint.ignore()) continue;
                        if (hint.name().length() > 0) {
                            name = hint.name();
                        }
                        order = hint.ordinal();
                    }
                    if (name == null && this.getPropertyCaseStyle() != null) {
                        name = this.getPropertyCaseStyle().to(prop.getName());
                    }
                    if (name != null) {
                        if (prop.getReadMethod() != null && prop.getField() != null) {
                            props.add(new PropertyInfo(prop.getBeanClass(), prop.getName(), prop.getField(), null, null, prop.isStatic(), order));
                            props.add(new PropertyInfo(prop.getBeanClass(), name, null, prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order));
                            continue;
                        }
                        props.add(new PropertyInfo(prop.getBeanClass(), name, prop.getField(), prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order));
                        continue;
                    }
                    if (order >= 0) {
                        props.add(new PropertyInfo(prop.getBeanClass(), prop.getName(), prop.getField(), prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order));
                        continue;
                    }
                    props.add(prop);
                }
                Collections.sort(props);
                this.memberCache.put(c, props);
            }
            return props;
        }

        /*
         * Enabled aggressive block sorting
         */
        Map<String, PropertyInfo> getSetProperties(Class<?> c) {
            HashMap<String, PropertyInfo> props;
            if (this.memberCache == null) {
                this.memberCache = new HashMap();
            }
            if ((props = (HashMap<String, PropertyInfo>)this.memberCache.get(c)) == null) {
                props = new HashMap<String, PropertyInfo>();
                for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
                    String name;
                    block9: {
                        if (prop.isStatic() || !prop.isWritable() || JSON.this.ignore(this, c, prop.getWriteMember())) continue;
                        name = null;
                        int order = -1;
                        JSONHint hint = prop.getWriteAnnotation(JSONHint.class);
                        if (hint != null) {
                            if (hint.ignore()) continue;
                            if (hint.name().length() > 0) {
                                name = hint.name();
                            }
                            order = hint.ordinal();
                        }
                        if (name != null) {
                            if (prop.getWriteMethod() != null && prop.getField() != null && !Modifier.isFinal(prop.getField().getModifiers())) {
                                props.put(name, new PropertyInfo(prop.getBeanClass(), name, null, prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order));
                                prop = new PropertyInfo(prop.getBeanClass(), prop.getName(), prop.getField(), null, null, prop.isStatic(), order);
                                break block9;
                            } else {
                                props.put(name, new PropertyInfo(prop.getBeanClass(), name, prop.getField(), prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order));
                                continue;
                            }
                        }
                        if (order >= 0) {
                            prop = new PropertyInfo(prop.getBeanClass(), prop.getName(), prop.getField(), prop.getReadMethod(), prop.getWriteMethod(), prop.isStatic(), order);
                        }
                    }
                    props.put(prop.getName(), prop);
                    if (this.getPropertyCaseStyle() == null) continue;
                    name = this.getPropertyCaseStyle().to(prop.getName());
                    if (prop.getName().equals(name)) continue;
                    props.put(name, prop);
                }
                this.memberCache.put(c, props);
            }
            return props;
        }

        NumberFormat getNumberFormat() {
            String format;
            JSONHint hint = this.getHint();
            String string = format = hint != null && hint.format().length() > 0 ? hint.format() : this.numberFormat;
            if (format != null) {
                NumberFormat nformat = null;
                if (this.numberFormatCache == null) {
                    this.numberFormatCache = new HashMap<String, NumberFormat>();
                } else {
                    nformat = this.numberFormatCache.get(format);
                }
                if (nformat == null) {
                    nformat = new DecimalFormat(format, new DecimalFormatSymbols(this.locale));
                    this.numberFormatCache.put(format, nformat);
                }
                return nformat;
            }
            return null;
        }

        DateFormat getDateFormat() {
            String format;
            JSONHint hint = this.getHint();
            String string = format = hint != null && hint.format().length() > 0 ? hint.format() : this.dateFormat;
            if (format != null) {
                DateFormat dformat = null;
                if (this.dateFormatCache == null) {
                    this.dateFormatCache = new HashMap<String, DateFormat>();
                } else {
                    dformat = this.dateFormatCache.get(format);
                }
                if (dformat == null) {
                    dformat = new ExtendedDateFormat(format, this.locale);
                    dformat.setTimeZone(this.timeZone);
                    this.dateFormatCache.put(format, dformat);
                }
                return dformat;
            }
            return null;
        }

        public String toString() {
            StringBuilderOutputSource sb = new StringBuilderOutputSource(this.getCachedBuffer());
            for (int i = 0; i < this.path.length; i += 2) {
                Object key = this.path[i];
                if (key == null) {
                    sb.append("[null]");
                    continue;
                }
                if (key instanceof Number) {
                    sb.append('[');
                    sb.append(key.toString());
                    sb.append(']');
                    continue;
                }
                if (key instanceof Character) {
                    sb.append(key.toString());
                    continue;
                }
                String str = key.toString();
                boolean escape = false;
                for (int j = 0; j < str.length(); ++j) {
                    if (j == 0) {
                        escape = !Character.isJavaIdentifierStart(str.charAt(j));
                    } else {
                        boolean bl = escape = !Character.isJavaIdentifierPart(str.charAt(j));
                    }
                    if (escape) break;
                }
                if (escape) {
                    sb.append('[');
                    try {
                        StringFormatter.serialize(this, str, sb);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    sb.append(']');
                    continue;
                }
                sb.append('.');
                sb.append(str);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRADITIONAL,
        STRICT,
        SCRIPT;

    }
}

