/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprVisitorFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class ExprWalker {
    ExprVisitor visitor;

    public ExprWalker(ExprVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void walk(ExprVisitor visitor, Expr expr) {
        expr.visit(new WalkerBottomUp(visitor));
    }

    public static class WalkerBottomUp
    extends Walker {
        private WalkerBottomUp(ExprVisitor visitor) {
            super(visitor, false);
        }
    }

    public static class WalkerTopDown
    extends Walker {
        private WalkerTopDown(ExprVisitor visitor) {
            super(visitor, true);
        }
    }

    static class Walker
    extends ExprVisitorFunction {
        ExprVisitor visitor;
        boolean topDown = true;

        private Walker(ExprVisitor visitor, boolean topDown) {
            this.visitor = visitor;
            this.topDown = topDown;
        }

        @Override
        public void startVisit() {
        }

        @Override
        protected void visitExprFunction(ExprFunction func) {
            if (this.topDown) {
                func.visit(this.visitor);
            }
            for (int i = 1; i <= func.numArgs(); ++i) {
                Expr expr = func.getArg(i);
                if (expr == null) {
                    NodeValue.nvNothing.visit(this);
                    continue;
                }
                expr.visit(this);
            }
            if (!this.topDown) {
                func.visit(this.visitor);
            }
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            funcOp.visit(this.visitor);
        }

        @Override
        public void visit(NodeValue nv) {
            nv.visit(this.visitor);
        }

        @Override
        public void visit(ExprVar v) {
            v.visit(this.visitor);
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            eAgg.visit(this.visitor);
        }

        @Override
        public void finishVisit() {
        }
    }
}

