/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateBinaryOp;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;

public class UpdateWriter {
    public static void output(UpdateRequest request, IndentedWriter out) {
        UpdateWriter.output(request, out, new SerializationContext(request));
    }

    public static void output(UpdateRequest request, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt == null) {
            sCxt = new SerializationContext(request);
        }
        UpdateWriter.prologue(out, sCxt.getPrologue());
        boolean addSeparator = request.getOperations().size() > 1;
        boolean first = true;
        for (Update update2 : request.getOperations()) {
            out.ensureStartOfLine();
            if (!first) {
                out.println();
            }
            first = false;
            UpdateWriter.outputUpdate(update2, out, sCxt);
            if (!addSeparator) continue;
            out.print(" ;");
        }
        out.ensureStartOfLine();
        out.flush();
    }

    public static void output(Update update2, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        UpdateWriter.prologue(out, sCxt.getPrologue());
        UpdateWriter.outputUpdate(update2, out, sCxt);
        out.flush();
    }

    private static void outputUpdate(Update update2, IndentedWriter out, SerializationContext sCxt) {
        Writer writer = new Writer(out, sCxt);
        update2.visit(writer);
    }

    private static void prologue(IndentedWriter out, Prologue prologue) {
        int row1 = out.getRow();
        PrologueSerializer.output(out, prologue);
        int row2 = out.getRow();
        if (row1 != row2) {
            out.newline();
        }
    }

    private static class Writer
    implements UpdateVisitor {
        private static final int BLOCK_INDENT = 2;
        private final IndentedWriter out;
        private final SerializationContext sCxt;

        public Writer(IndentedWriter out, SerializationContext sCxt) {
            this.out = out;
            this.sCxt = sCxt;
        }

        private void visitDropClear(String name, UpdateDropClear update2) {
            this.out.ensureStartOfLine();
            this.out.print(name);
            this.out.print(" ");
            if (update2.isSilent()) {
                this.out.print("SILENT ");
            }
            this.printTarget(update2.getTarget());
        }

        private void printTarget(Target target) {
            if (target.isAll()) {
                this.out.print("ALL");
            } else if (target.isAllNamed()) {
                this.out.print("NAMED");
            } else if (target.isDefault()) {
                this.out.print("DEFAULT");
            } else if (target.isOneNamedGraph()) {
                this.out.print("GRAPH ");
                String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
                this.out.print(s);
            } else {
                this.out.print("Target BROKEN");
                throw new ARQException("Malformed Target");
            }
        }

        @Override
        public void visit(UpdateDrop update2) {
            this.visitDropClear("DROP", update2);
        }

        @Override
        public void visit(UpdateClear update2) {
            this.visitDropClear("CLEAR", update2);
        }

        @Override
        public void visit(UpdateCreate update2) {
            this.out.ensureStartOfLine();
            this.out.print("CREATE");
            this.out.print(" ");
            if (update2.isSilent()) {
                this.out.print("SILENT ");
            }
            String s = FmtUtils.stringForNode(update2.getGraph(), this.sCxt);
            this.out.print(s);
        }

        @Override
        public void visit(UpdateLoad update2) {
            this.out.ensureStartOfLine();
            this.out.print("LOAD");
            this.out.print(" ");
            if (update2.getSilent()) {
                this.out.print("SILENT ");
            }
            this.outputStringAsURI(update2.getSource());
            if (update2.getDest() != null) {
                this.out.print(" INTO GRAPH ");
                this.output(update2.getDest());
            }
        }

        private void outputStringAsURI(String uriStr) {
            String x = FmtUtils.stringForURI(uriStr, this.sCxt);
            this.out.print(x);
        }

        private void printTargetUpdate2(Target target) {
            if (target.isDefault()) {
                this.out.print("DEFAULT");
            } else if (target.isOneNamedGraph()) {
                String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
                this.out.print(s);
            } else {
                this.out.print("Target BROKEN / Update2");
                throw new ARQException("Malformed Target / Update2");
            }
        }

        private void printUpdate2(UpdateBinaryOp update2, String name) {
            this.out.print(name);
            if (update2.getSilent()) {
                this.out.print(" SILENT");
            }
            this.out.print(" ");
            this.printTargetUpdate2(update2.getSrc());
            this.out.print(" TO ");
            this.printTargetUpdate2(update2.getDest());
        }

        @Override
        public void visit(UpdateAdd update2) {
            this.printUpdate2(update2, "ADD");
        }

        @Override
        public void visit(UpdateCopy update2) {
            this.printUpdate2(update2, "COPY");
        }

        @Override
        public void visit(UpdateMove update2) {
            this.printUpdate2(update2, "MOVE");
        }

        @Override
        public void visit(UpdateDataInsert update2) {
            this.out.ensureStartOfLine();
            this.out.print("INSERT DATA ");
            this.outputQuadsBraced(update2.getQuads());
        }

        @Override
        public void visit(UpdateDataDelete update2) {
            this.out.ensureStartOfLine();
            this.out.print("DELETE DATA ");
            this.outputQuadsBraced(update2.getQuads());
        }

        private void outputQuadsBraced(List<Quad> quads) {
            if (quads.size() == 0) {
                this.out.print("{ }");
                return;
            }
            this.out.println("{");
            this.outputQuads(quads);
            this.out.print("}");
        }

        private void outputQuads(List<Quad> quads) {
            this.out.incIndent(2);
            Node g = Quad.tripleInQuad;
            boolean inBlock = false;
            for (Quad q : quads) {
                if (q.getGraph() != g) {
                    if (inBlock) {
                        this.out.decIndent(2);
                        this.out.println("}");
                        inBlock = false;
                    }
                    g = q.getGraph();
                    if (!q.isTriple() && !q.isDefaultGraphGenerated()) {
                        this.out.print("GRAPH ");
                        this.output(g);
                        this.out.println(" {");
                        this.out.incIndent(2);
                        inBlock = true;
                    }
                }
                this.outputTripleOfQuad(q);
                this.out.println(" .");
            }
            if (inBlock) {
                this.out.decIndent(2);
                this.out.println("}");
                inBlock = false;
            }
            this.out.decIndent(2);
        }

        private void output(Node node) {
            String $ = FmtUtils.stringForNode(node, this.sCxt);
            this.out.print($);
        }

        private void outputQuad(Quad quad) {
            String qs = FmtUtils.stringForQuad(quad, this.sCxt.getPrefixMapping());
            if (quad.getGraph() != null) {
                String g = FmtUtils.stringForNode(quad.getGraph(), this.sCxt);
                this.out.print(g);
                this.out.print(" ");
            }
            this.outputTripleOfQuad(quad);
            this.out.println(" .");
        }

        private void outputTripleOfQuad(Quad quad) {
            String s = FmtUtils.stringForNode(quad.getSubject(), this.sCxt);
            String p = FmtUtils.stringForNode(quad.getPredicate(), this.sCxt);
            String o = FmtUtils.stringForNode(quad.getObject(), this.sCxt);
            this.out.print(s);
            this.out.print(" ");
            this.out.print(p);
            this.out.print(" ");
            this.out.print(o);
        }

        @Override
        public void visit(UpdateDeleteWhere update2) {
            this.out.ensureStartOfLine();
            this.out.println("DELETE WHERE ");
            this.outputQuadsBraced(update2.getQuads());
        }

        @Override
        public void visit(UpdateModify update2) {
            this.out.ensureStartOfLine();
            if (update2.getWithIRI() != null) {
                this.out.print("WITH ");
                this.output(update2.getWithIRI());
            }
            if (update2.hasDeleteClause()) {
                List<Quad> deleteQuads = update2.getDeleteQuads();
                this.out.ensureStartOfLine();
                this.out.print("DELETE ");
                this.outputQuadsBraced(deleteQuads);
            }
            if (update2.hasInsertClause()) {
                List<Quad> insertQuads = update2.getInsertQuads();
                this.out.ensureStartOfLine();
                this.out.print("INSERT ");
                this.outputQuadsBraced(insertQuads);
            }
            if (!update2.hasInsertClause() && !update2.hasDeleteClause()) {
                this.out.ensureStartOfLine();
                this.out.println("INSERT { }");
            }
            for (Node x : update2.getUsing()) {
                this.out.ensureStartOfLine();
                this.out.print("USING ");
                this.output(x);
            }
            for (Node x : update2.getUsingNamed()) {
                this.out.ensureStartOfLine();
                this.out.print("USING NAMED ");
                this.output(x);
            }
            Element el = update2.getWherePattern();
            this.out.ensureStartOfLine();
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            if (el != null) {
                FormatterElement fmtElement = new FormatterElement(this.out, this.sCxt);
                fmtElement.visitAsGroup(el);
            } else {
                this.out.print("{}");
            }
            this.out.decIndent(2);
        }
    }
}

