/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemTransform;
import com.hp.hpl.jena.sparql.sse.ItemVisitor;
import java.util.Stack;

public class ItemTransformer {
    public static Item transform(ItemTransform transform, Item item) {
        TransformerApply v = new TransformerApply(transform);
        item.visit(v);
        return v.result();
    }

    static class TransformerApply
    implements ItemVisitor {
        Stack<Item> stack = new Stack();
        private ItemTransform transform;

        private void push(Item item) {
            this.stack.push(item);
        }

        private Item pop() {
            return this.stack.pop();
        }

        public TransformerApply(ItemTransform transform) {
            this.transform = transform;
        }

        public Item result() {
            return this.stack.peek();
        }

        @Override
        public void visit(Item item, ItemList list) {
            ItemList newList = new ItemList(item.getLine(), item.getColumn());
            for (Item subItem : list) {
                subItem.visit(this);
                Item newItem = this.pop();
                newList.add(newItem);
            }
            Item newItemList = Item.createList(newList, item.getLine(), item.getColumn());
            this.push(newItemList);
        }

        @Override
        public void visit(Item item, Node node) {
            Item newItem = this.transform.transform(item, node);
            this.push(newItem);
        }

        @Override
        public void visit(Item item, String symbol) {
            Item newItem = this.transform.transform(item, symbol);
            this.push(newItem);
        }

        @Override
        public void visitNil() {
            this.push(Item.nil);
        }
    }
}

