/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.iri.IRI;
import org.openjena.atlas.logging.Log;
import org.openjena.riot.system.PrefixMap;

public class PrefixMap2
extends PrefixMap {
    PrefixMap parent;
    PrefixMap local;

    public PrefixMap2(PrefixMap parent) {
        this.parent = parent;
        this.local = new PrefixMap();
    }

    @Override
    public void add(String prefix, IRI iri2) {
        prefix = PrefixMap2.canonicalPrefix(prefix);
        this.local.add(prefix, iri2);
    }

    @Override
    public void delete(String prefix) {
        prefix = PrefixMap2.canonicalPrefix(prefix);
        this.local.delete(prefix);
        if (this.parent._contains(prefix)) {
            Log.warn(this, "Attempt to delete a prefix in the parent");
        }
    }

    @Override
    public String expand(String prefix, String localName) {
        String x = this.local.expand(prefix = PrefixMap2.canonicalPrefix(prefix), localName);
        if (x != null) {
            return x;
        }
        return this.parent.expand(prefix, localName);
    }
}

