/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphUnion;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;

public class AGGraphMaker
implements GraphMaker,
Closeable {
    private AGRepositoryConnection conn;
    private ReificationStyle style;
    private AGGraph defaultGraph;
    protected Map<String, AGGraph> created = CollectionFactory.createHashedMap();

    public AGGraphMaker(AGRepositoryConnection conn) {
        this(conn, ReificationStyle.Minimal);
    }

    public AGGraphMaker(AGRepositoryConnection conn, ReificationStyle style) {
        this.conn = conn;
        conn.getHttpRepoClient().setAllowExternalBlankNodeIds(true);
        this.style = style;
    }

    public AGRepositoryConnection getRepositoryConnection() {
        return this.conn;
    }

    @Override
    public void close() {
    }

    public AGGraph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = new AGGraph(this, null);
        }
        return this.defaultGraph;
    }

    public AGGraph createGraph() {
        String id = this.conn.getValueFactory().createBNode().getID();
        Node anon = Node.createAnon((AnonId)AnonId.create((String)id));
        return new AGGraph(this, anon);
    }

    public AGGraph createGraph(String uri) {
        return this.createGraph(uri, false);
    }

    public AGGraph createGraph(String uri, boolean strict) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            Node node = Node.createURI((String)this.absUriFromString(uri));
            g = new AGGraph(this, node);
            this.created.put(uri, g);
        } else if (strict) {
            throw new AlreadyExistsException(uri);
        }
        return g;
    }

    private String absUriFromString(String name) {
        String uri = name;
        if (name.indexOf(58) < 0) {
            uri = "urn:x-franz:" + name;
        }
        return uri;
    }

    public ReificationStyle getReificationStyle() {
        return this.style;
    }

    public boolean hasGraph(String uri) {
        return null != this.created.get(uri);
    }

    public ExtendedIterator<String> listGraphs() {
        return new NiceIterator().andThen(this.created.keySet().iterator());
    }

    public AGGraph openGraph() {
        return this.getGraph();
    }

    public AGGraph openGraph(String name) {
        return this.openGraph(name, false);
    }

    public AGGraph openGraph(String uri, boolean strict) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            if (strict) {
                throw new DoesNotExistException(uri);
            }
            Node node = Node.createURI((String)this.absUriFromString(uri));
            g = new AGGraph(this, node);
            this.created.put(uri, g);
        }
        return g;
    }

    public void removeGraph(String uri) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            throw new DoesNotExistException(uri);
        }
        try {
            g.getConnection().clear(new Resource[]{g.getGraphContext()});
            this.created.remove(uri);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public AGGraph getUnionOfAllGraphs() {
        return this.createUnion(new AGGraph[0]);
    }

    public AGGraphUnion createUnion(AGGraph ... graphs) {
        HashSet<Resource> contexts = new HashSet<Resource>();
        for (AGGraph g : graphs) {
            contexts.addAll(Arrays.asList(g.getGraphContexts()));
        }
        Resource context = null;
        if (graphs.length > 0) {
            context = graphs[0].getGraphContext();
        }
        return new AGGraphUnion(this, context, contexts.toArray(new Resource[contexts.size()]));
    }
}

