/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.hp.hpl.jena.graph.Node;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class AGValueFactory
extends ValueFactoryImpl {
    private final AGRepository repository;
    private final AGRepositoryConnection conn;
    private int blankNodeAmount = 100;
    private String[] blankNodeIds;
    private int index = -1;
    public String PREFIX_FOR_EXTERNAL_BNODES = "urn:x-bnode:";

    public AGValueFactory(AGRepository repository) {
        this.repository = repository;
        this.conn = null;
    }

    public AGValueFactory(AGRepository repository, AGRepositoryConnection conn) {
        this.repository = repository;
        this.conn = conn;
    }

    public AGRepository getRepository() {
        return this.repository;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getRepository().getHTTPClient();
    }

    private void getBlankNodeIds() {
        try {
            this.blankNodeIds = this.conn == null ? this.getHTTPClient().getBlankNodes(this.getRepository().getRepositoryURL(), this.blankNodeAmount) : this.conn.getHttpRepoClient().getBlankNodes(this.blankNodeAmount);
            this.index = this.blankNodeIds.length - 1;
        }
        catch (AGHttpException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    String getNextBNodeId() {
        if (this.index == -1) {
            this.getBlankNodeIds();
        }
        String id = this.blankNodeIds[this.index];
        --this.index;
        return id.substring(2);
    }

    public BNode createBNode(String nodeID) {
        if (nodeID == null || "".equals(nodeID)) {
            nodeID = this.getNextBNodeId();
        }
        return super.createBNode(nodeID);
    }

    public BNode createBNode() {
        if (this.repository instanceof AGRepository) {
            return this.createBNode(null);
        }
        return super.createBNode();
    }

    public Value asValue(Node node) {
        URI val;
        if (node == null || node == Node.ANY) {
            val = null;
        } else if (node.isURI()) {
            val = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            String id = node.getBlankNodeLabel();
            val = this.createBNode(id);
        } else if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            if (node.getLiteralDatatypeURI() != null) {
                URI datatype = this.createURI(node.getLiteralDatatypeURI());
                val = this.createLiteral(node.getLiteralLexicalForm(), datatype);
            } else {
                val = lang != null && !lang.equals("") ? this.createLiteral(node.getLiteralLexicalForm(), lang) : this.createLiteral(node.getLiteralLexicalForm());
            }
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Value: " + node);
        }
        return val;
    }

    public boolean isAGBlankNodeId(String id) {
        boolean endsWithNumber;
        boolean storeIdThenX;
        boolean startsWithB = id.startsWith("b");
        if (!startsWithB) {
            return false;
        }
        boolean bl = id.length() > 9 ? id.charAt(9) == 'x' : (storeIdThenX = false);
        if (!storeIdThenX) {
            return false;
        }
        try {
            Long.parseLong(id.substring(10));
            endsWithNumber = true;
        }
        catch (NumberFormatException e) {
            endsWithNumber = false;
        }
        return endsWithNumber;
    }

    public boolean isURIForExternalBlankNode(Value v) {
        return v.stringValue().startsWith(this.PREFIX_FOR_EXTERNAL_BNODES);
    }

    public Resource asResource(Node node) {
        URI res;
        if (node == null || node == Node.ANY) {
            res = null;
        } else if (node.isURI()) {
            res = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            res = this.createBNode(node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Resource: " + node);
        }
        return res;
    }

    public URI asURI(Node node) {
        URI uri;
        if (node == null || node == Node.ANY) {
            uri = null;
        } else if (node.isURI()) {
            uri = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            uri = this.createURI("http://anon/" + node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to URI: " + node);
        }
        return uri;
    }

    public URI[] generateURIs(String namespace, int amount) throws RepositoryException {
        URI[] uris;
        try {
            String[] uri_strs = this.getHTTPClient().generateURIs(this.getRepository().getRepositoryURL(), namespace, amount);
            uris = new URI[uri_strs.length];
            for (int i = 0; i < uri_strs.length; ++i) {
                uris[i] = NTriplesUtil.parseURI((String)uri_strs[i], (ValueFactory)this);
            }
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        return uris;
    }

    public URI generateURI(String registeredEncodableNamespace) throws RepositoryException {
        return this.generateURIs(registeredEncodableNamespace, 1)[0];
    }
}

