/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbitraryLengthPath
extends QueryModelNodeBase
implements TupleExpr {
    private StatementPattern.Scope scope;
    private Var subjectVar;
    private TupleExpr pathExpression;
    private Var objectVar;
    private Var contextVar;
    private long minLength;

    public ArbitraryLengthPath() {
    }

    public ArbitraryLengthPath(Var subject, TupleExpr pathExpression, Var object, long minLength) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, pathExpression, object, minLength);
    }

    public ArbitraryLengthPath(StatementPattern.Scope scope, Var subject, TupleExpr pathExpression, Var object, long minLength) {
        this(scope, subject, pathExpression, object, null, minLength);
    }

    public ArbitraryLengthPath(Var subject, TupleExpr pathExpression, Var object, Var context, long minLength) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, pathExpression, object, context, minLength);
    }

    public ArbitraryLengthPath(StatementPattern.Scope scope, Var subjVar, TupleExpr pathExpression, Var objVar, Var conVar, long minLength) {
        this.setScope(scope);
        this.setSubjectVar(subjVar);
        this.setPathExpression(pathExpression);
        this.setObjectVar(objVar);
        this.setContextVar(conVar);
        this.setMinLength(minLength);
    }

    public StatementPattern.Scope getScope() {
        return this.scope;
    }

    public void setScope(StatementPattern.Scope scope) {
        assert (scope != null) : "scope must not be null";
        this.scope = scope;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public void setSubjectVar(Var subject) {
        assert (subject != null) : "subject must not be null";
        subject.setParentNode(this);
        this.subjectVar = subject;
    }

    public TupleExpr getPathExpression() {
        return this.pathExpression;
    }

    public void setPathExpression(TupleExpr pathExpression) {
        pathExpression.setParentNode(this);
        this.pathExpression = pathExpression;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public void setObjectVar(Var object) {
        assert (object != null) : "object must not be null";
        object.setParentNode(this);
        this.objectVar = object;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setContextVar(Var context) {
        if (context != null) {
            context.setParentNode(this);
        }
        this.contextVar = context;
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>(8);
        if (this.subjectVar != null) {
            bindingNames.add(this.subjectVar.getName());
        }
        if (this.pathExpression != null) {
            bindingNames.addAll(this.pathExpression.getAssuredBindingNames());
        }
        if (this.objectVar != null) {
            bindingNames.add(this.objectVar.getName());
        }
        if (this.contextVar != null) {
            bindingNames.add(this.contextVar.getName());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.pathExpression != null) {
            this.pathExpression.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.contextVar != null) {
            this.contextVar.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            this.setSubjectVar((Var)replacement);
        } else if (this.pathExpression == current) {
            this.setPathExpression((TupleExpr)replacement);
        } else if (this.objectVar == current) {
            this.setObjectVar((Var)replacement);
        } else if (this.contextVar == current) {
            this.setContextVar((Var)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            sb.append(" FROM NAMED CONTEXT");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ArbitraryLengthPath) {
            ArbitraryLengthPath o = (ArbitraryLengthPath)other;
            return this.subjectVar.equals(o.getSubjectVar()) && this.pathExpression.equals(o.getPathExpression()) && this.objectVar.equals(o.getObjectVar()) && this.nullEquals(this.contextVar, o.getContextVar()) && this.scope.equals((Object)o.getScope());
        }
        return false;
    }

    public int hashCode() {
        int result = this.subjectVar.hashCode();
        result ^= this.pathExpression.hashCode();
        result ^= this.objectVar.hashCode();
        if (this.contextVar != null) {
            result ^= this.contextVar.hashCode();
        }
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public ArbitraryLengthPath clone() {
        ArbitraryLengthPath clone = (ArbitraryLengthPath)super.clone();
        clone.setSubjectVar(this.getSubjectVar().clone());
        clone.setPathExpression(this.getPathExpression().clone());
        clone.setObjectVar(this.getObjectVar().clone());
        if (this.getContextVar() != null) {
            clone.setContextVar(this.getContextVar().clone());
        }
        return clone;
    }
}

