/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.util;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -1102573423774831657L;
    private int maxSize;

    public LRUMap() {
        this(Integer.MAX_VALUE);
    }

    public LRUMap(int maxSize) {
        this(maxSize, 16, 0.75f);
    }

    public LRUMap(int maxSize, int initialCapacity) {
        this(maxSize, initialCapacity, 0.75f);
    }

    public LRUMap(int maxSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.maxSize = maxSize;
    }

    public LRUMap(Map<? extends K, ? extends V> m) {
        this(m.size());
        this.putAll(m);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.getMaxSize();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int i) {
        this.maxSize = i;
    }
}

