package org.biohackathon.SPARQLBuilder.OWL;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * 起点となるリソースから逐次的に複数リンクで終点リソースまで接続される一つのパスを記述する
 * 
 * @author Yamaguchi
 * @since 28.01.2014
 * @version 29.01.2014
 */
public class Path {

	/**
	 * パスの起点となるクラスのURI
	 */
	private String startClass;
	private int width;

	/**
	 * パスの起点から終点に向かって逐次的につながるクラス間リンクのリスト
	 */
	private List<ClassLink> classLinks;

	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("startClassURI", startClass);
		obj.put("width", width);
		if (classLinks != null && classLinks.size() != 0) {
			JSONObject[] classLinkObjs = new JSONObject[classLinks.size()];
			for (int i = 0; i < classLinks.size(); i++) {
				classLinkObjs[i] = classLinks.get(i).toJSON();
			}
			JSONArray array = new JSONArray(classLinkObjs);
			obj.put("classLinks", array);
		}
		return obj;
	}
	
	public String toJSONString(){
		return toJSON().toString();
	}

	public String getStartClass() {
		return startClass;
	}

	/*
	 * public String[] getProperties(){ return properties; }
	 * 
	 * public String[] getObjectClasses(){ return objectClasses; }
	 * 
	 * public Direction[] getDirections(){ return directions; }
	 */
	public List<ClassLink> getClassLinks() {
		return classLinks;
	}

	public int getWidth() {
		return width;
	}

	public Path() {
	}

	public Path(String startClass, List<ClassLink> classLinks, int width) {
		this.startClass = startClass;
		this.classLinks = classLinks;
		this.width = width;
	}

	public void setStartClass(String startClass) {
		this.startClass = startClass;
	}

	public void setClassLinks(List<ClassLink> classLinks) {
		this.classLinks = classLinks;
	}

	public void setWidth(int width) {
		this.width = width;
	}

}