package org.biohackathon.SPARQLBuilder.OWL;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import jp.riken.accc.db.rdf.crawler.dataStructure.sparql.JenaModelGenerator;

public class RDFSchemaAnalyzerFactory {

	private Map<String, String> acquiredRDFFiles = null;

	public void setAcqiredRDFFiles(File data){
		if( data.isDirectory() ){
			// read files
			File[] files = data.listFiles();
			acquiredRDFFiles = new HashMap<String, String>();
			for(File file: files){
				String uri = null;
				try{
					JenaModelGenerator jmGene = new JenaModelGenerator(data.getAbsolutePath());
					uri = jmGene.getEndpointURI();
				}catch(Exception ex){
					//
				}
				if( uri != null ){
					acquiredRDFFiles.put(uri, data.getAbsolutePath());
				}
			}
		}else{
			if( data.isFile() ){
				String uri = null;
				try{
					JenaModelGenerator jmGene = new JenaModelGenerator(data.getAbsolutePath());
					uri = jmGene.getEndpointURI();
				}catch(Exception ex){
					//
				}
				if( uri != null ){
					acquiredRDFFiles = new HashMap<String, String>();
					acquiredRDFFiles.put(uri, data.getAbsolutePath());
				}
			}
		}
	}
	
	public RDFSchemaAnalyzer create(String uri) throws Exception{
		if( acquiredRDFFiles == null || !acquiredRDFFiles.containsKey(uri)){
			return new EndpointAnalyzer(uri);
		}else{
			JenaModelGenerator jmGene = new JenaModelGenerator(acquiredRDFFiles.get(uri));
			return new AcquiredStructureAnalyzer(jmGene.getEndpointURI(), jmGene.getGraphURIs(), jmGene.getModel());
		}
	}

	
	
	
}
