package org.biohackathon.SPARQLBuilder.OWL;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import jp.riken.accc.db.rdf.crawler.dataStructure.sparql.JenaModelGenerator;

public class RDFSchemaAnalyzerFactory {

	private Map<String, String> acquiredRDFFiles = null;

	public void setAcqiredRDFFiles(File data) throws Exception{
		StructureCrawler sc = new StructureCrawler(data);
		acquiredRDFFiles = sc.getAcquiredStructureFiles();
	}
	
	
	public RDFSchemaAnalyzer create(String uri) throws Exception{
		if( acquiredRDFFiles == null || !acquiredRDFFiles.containsKey(uri)){
			return new EndpointAnalyzer(uri);
		}else{
			JenaModelGenerator jmGene = new JenaModelGenerator(acquiredRDFFiles.get(uri));
			return new AcquiredStructureAnalyzer(jmGene.getEndpointURI(), jmGene.getGraphURIs(), jmGene.getModel());
		}
	}

	
	
	
}
