package hozo.sparql.gui;

import javax.swing.JPanel;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import java.awt.GridBagLayout;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JTextField;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import javax.swing.JRadioButton;
import javax.swing.JPasswordField;

public class OptionDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel footerPanel = null;
	private JButton okButton = null;
	private JButton cancelButton = null;
	private JPanel mainPanel = null;
	private JTextField queryKeyTextField = null;
	private JTextField optionTextField = null;
	private JLabel queryKeyLabel = null;
	private JLabel optionLabel = null;
	private JLabel encodingLabel = null;
	private JTextField encodingTextField = null;
	private JLabel resultTypeLabel = null;
	private JComboBox dataFormatComboBox = null;
	
	private boolean isOk;
	private JLabel endpointLabel = null;
	private JTextField endpointTextField = null;
	private JLabel queryTypeLabel = null;
	private JPanel queryTypePanel = null;
	private JRadioButton queryTypeDefaultRadioButton = null;
	private JRadioButton queryTypeCustomRadioButton = null;
	private JLabel namespacesLabel = null;
	private JTextField namespacesTextField = null;
	private JLabel repositoryTypeLabel = null;
	private JPanel repositoryTypePanel = null;
	private JRadioButton repositoryOnRadioButton = null;
	private JRadioButton repositoryOffRadioButton = null;
	private JLabel repositoryLabel = null;
	private JTextField repositoryTextField = null;
	private JLabel userLabel = null;
	private JLabel passLabel = null;
	private JTextField userTextField = null;
	private JPasswordField passPasswordField = null;
	private JLabel urlLabel = null;
	private JTextField repositoryUrlTextField = null;
	/**
	 * @param owner
	 */
	public OptionDialog(Frame owner, String endpoint) {
		super(owner);
		initialize();
		
		this.getEndpointTextField().setText(endpoint);
	}

	public OptionDialog(Frame owner, EndpointSettings setting) {
		super(owner);
		initialize();
		
		setCurrentEndpoint(setting);
	}
	
	private void setCurrentEndpoint(EndpointSettings setting){
		this.getEndpointTextField().setText(setting.getEndpoint());
		this.setUseCustom(setting.isUseCustomParam());
		this.setEncoding(setting.getEncoding());
		this.setQueryKey(setting.getQueryKey());
		this.setOption(setting.getOption());
		this.setNamespaces(setting.getNamespaces());
		this.setResultType(setting.getResultType());
		
		this.setEditable(setting.isEditable());
		this.setRepositoryURL(setting.getRepositoryURL());
		this.setRepository(setting.getRepository());
		this.setUser(setting.getUser());
		this.setPassword(setting.getPass());
	}

	
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(545, 631);
		this.setContentPane(getJContentPane());
	}
	
	public void setUseCustom(boolean custom){
		this.getQueryTypeDefaultRadioButton().setSelected(!custom);
		this.getQueryTypeCustomRadioButton().setSelected(custom);
		this.setCustomEnabled(custom);
	}
	
	public boolean isUseCustom(){
		return this.getQueryTypeCustomRadioButton().isSelected();
	}
	
	public void setQueryKey(String key){
		this.getQueryKeyTextField().setText(key);
	}
	
	public String getQueryKey(){
		return this.getQueryKeyTextField().getText();
	}
	
	public void setOption(String opt){
		this.getOptionTextField().setText(opt);
	}
	
	public String getOption(){
		return this.getOptionTextField().getText();
	}

	public void setNamespaces(String namespaces){
		this.getNamespacesTextField().setText(namespaces);
	}
	
	public String getNamespaces(){
		return this.getNamespacesTextField().getText();
	}

	public void setEncoding(String encode){
		this.getEncodingTextField().setText(encode);
	}
	
	public String getEndoding(){
		return this.getEncodingTextField().getText();
	}
	
	public void setResultType(Integer type){
		this.getDataFormatComboBox().setSelectedItem(EndpointSettings.getResultDataType(type));
	}

	public Integer getResultType(){
		return EndpointSettings.getResultDataType((String)this.getDataFormatComboBox().getSelectedItem());
	}
	
	public boolean isEditable(){
		return this.getRepositoryOnRadioButton().isSelected();
	}
	
	public void setEditable(boolean isEditable){
		this.getRepositoryOnRadioButton().setSelected(isEditable);
		this.getRepositoryOffRadioButton().setSelected(!isEditable);
		this.setEditEnabled(isEditable);
	}

	public String getRepositoryURL(){
		return this.getRepositoryUrlTextField().getText();
	}
	
	public void setRepositoryURL(String repo){
		this.getRepositoryUrlTextField().setText(repo);
	}

	public String getRepository(){
		return this.getRepositoryTextField().getText();
	}
	
	public void setRepository(String repo){
		this.getRepositoryTextField().setText(repo);
	}
	
	public String getUser(){
		return this.getUserTextField().getText();
	}
	
	public void setUser(String user){
		this.getUserTextField().setText(user);
	}
	
	public String getPassword(){
		return new String(this.getPassPasswordField().getPassword());
	}
	
	public void setPassword(String pass){
		this.getPassPasswordField().setText(pass);
	}
	
	
	public boolean isOk(){
		return this.isOk;
	}
	
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getFooterPanel(), BorderLayout.SOUTH);
			jContentPane.add(getMainPanel(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes footerPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getFooterPanel() {
		if (footerPanel == null) {
			footerPanel = new JPanel();
			footerPanel.setLayout(new FlowLayout());
			footerPanel.add(getOkButton());
			footerPanel.add(getCancelButton(), null);
		}
		return footerPanel;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					isOk = true;
					setVisible(false);
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton("CANCEL");
			cancelButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					isOk = false;
					setVisible(false);
				}
			});
		}
		return cancelButton;
	}

	/**
	 * This method initializes mainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMainPanel() {
		if (mainPanel == null) {
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.fill = GridBagConstraints.BOTH;
			gridBagConstraints10.gridy = 10;
			gridBagConstraints10.weightx = 1.0;
			gridBagConstraints10.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints10.gridx = 1;
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.gridx = 0;
			gridBagConstraints9.gridy = 10;
			urlLabel = new JLabel();
			urlLabel.setText("Repository URL");
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.fill = GridBagConstraints.BOTH;
			gridBagConstraints8.gridy = 13;
			gridBagConstraints8.weightx = 1.0;
			gridBagConstraints8.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints8.gridx = 1;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.fill = GridBagConstraints.BOTH;
			gridBagConstraints7.gridy = 12;
			gridBagConstraints7.weightx = 1.0;
			gridBagConstraints7.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints7.gridx = 1;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 0;
			gridBagConstraints6.gridy = 13;
			passLabel = new JLabel();
			passLabel.setText("Password");
			GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
			gridBagConstraints51.gridx = 0;
			gridBagConstraints51.gridy = 12;
			userLabel = new JLabel();
			userLabel.setText("User");
			GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
			gridBagConstraints41.fill = GridBagConstraints.BOTH;
			gridBagConstraints41.gridy = 11;
			gridBagConstraints41.weightx = 1.0;
			gridBagConstraints41.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints41.gridx = 1;
			GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
			gridBagConstraints32.gridx = 0;
			gridBagConstraints32.insets = new Insets(0, 10, 0, 5);
			gridBagConstraints32.gridy = 11;
			repositoryLabel = new JLabel();
			repositoryLabel.setText("Repository Name");
			GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
			gridBagConstraints25.gridx = 1;
			gridBagConstraints25.fill = GridBagConstraints.BOTH;
			gridBagConstraints25.insets = new Insets(0, 0, 0, 0);
			gridBagConstraints25.gridy = 9;
			GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
			gridBagConstraints15.gridx = 0;
			gridBagConstraints15.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints15.gridy = 9;
			repositoryTypeLabel = new JLabel();
			repositoryTypeLabel.setText("Editable AllegroGraph");
			GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
			gridBagConstraints24.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints24.gridy = 2;
			gridBagConstraints24.weightx = 1.0;
			gridBagConstraints24.insets = new Insets(0, 0, 0, 10);
			gridBagConstraints24.gridx = 1;
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.gridx = 0;
			gridBagConstraints14.insets = new Insets(15, 10, 15, 10);
			gridBagConstraints14.gridy = 2;
			namespacesLabel = new JLabel("Namespaces");
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = 1;
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.gridy = 3;
			GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
			gridBagConstraints31.gridx = 0;
			gridBagConstraints31.gridy = 3;
			queryTypeLabel = new JLabel("Query Type");
			GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
			gridBagConstraints23.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints23.gridy = 1;
			gridBagConstraints23.weightx = 1.0;
			gridBagConstraints23.insets = new Insets(0, 0, 0, 10);
			gridBagConstraints23.gridx = 1;
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.gridx = 0;
			gridBagConstraints13.insets = new Insets(15, 10, 15, 10);
			gridBagConstraints13.gridy = 1;
			endpointLabel = new JLabel("Endpoint");
			GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
			gridBagConstraints22.fill = GridBagConstraints.NONE;
			gridBagConstraints22.gridy = 8;
			gridBagConstraints22.weightx = 1.0;
			gridBagConstraints22.ipadx = 0;
			gridBagConstraints22.anchor = GridBagConstraints.WEST;
			gridBagConstraints22.insets = new Insets(15, 0, 15, 0);
			gridBagConstraints22.gridwidth = 0;
			gridBagConstraints22.gridx = 1;
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.gridx = 0;
			gridBagConstraints12.gridy = 8;
			resultTypeLabel = new JLabel("Result Format");
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints3.gridy = 7;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints3.gridx = 1;
			GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
			gridBagConstraints21.gridx = 0;
			gridBagConstraints21.gridy = 7;
			encodingLabel = new JLabel("Encoding");
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.insets = new Insets(10, 0, 10, 0);
			gridBagConstraints11.gridy = 5;
			optionLabel = new JLabel("Option");
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints2.gridy = 4;
			queryKeyLabel = new JLabel("Query Key");
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.gridy = 5;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.anchor = GridBagConstraints.CENTER;
			gridBagConstraints1.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints1.gridx = 1;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints.gridy = 4;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.gridheight = 1;
			gridBagConstraints.insets = new Insets(10, 0, 10, 10);
			gridBagConstraints.gridx = 1;
			mainPanel = new JPanel();
			mainPanel.setLayout(new GridBagLayout());
			mainPanel.add(getQueryKeyTextField(), gridBagConstraints);
			mainPanel.add(getOptionTextField(), gridBagConstraints1);
			mainPanel.add(queryKeyLabel, gridBagConstraints2);
			mainPanel.add(optionLabel, gridBagConstraints11);
			mainPanel.add(encodingLabel, gridBagConstraints21);
			mainPanel.add(getEncodingTextField(), gridBagConstraints3);
			mainPanel.add(resultTypeLabel, gridBagConstraints12);
			mainPanel.add(getDataFormatComboBox(), gridBagConstraints22);
			mainPanel.add(endpointLabel, gridBagConstraints13);
			mainPanel.add(getEndpointTextField(), gridBagConstraints23);
			mainPanel.add(queryTypeLabel, gridBagConstraints31);
			mainPanel.add(getQueryTypePanel(), gridBagConstraints5);
			mainPanel.add(namespacesLabel, gridBagConstraints14);
			mainPanel.add(getNamespacesTextField(), gridBagConstraints24);
			mainPanel.add(repositoryTypeLabel, gridBagConstraints15);
			mainPanel.add(getRepositoryTypePanel(), gridBagConstraints25);
			mainPanel.add(repositoryLabel, gridBagConstraints32);
			mainPanel.add(getRepositoryTextField(), gridBagConstraints41);
			mainPanel.add(userLabel, gridBagConstraints51);
			mainPanel.add(passLabel, gridBagConstraints6);
			mainPanel.add(getUserTextField(), gridBagConstraints7);
			mainPanel.add(getPassPasswordField(), gridBagConstraints8);
			mainPanel.add(urlLabel, gridBagConstraints9);
			mainPanel.add(getRepositoryUrlTextField(), gridBagConstraints10);
			
		}
		return mainPanel;
	}

	/**
	 * This method initializes queryKeyTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getQueryKeyTextField() {
		if (queryKeyTextField == null) {
			queryKeyTextField = new JTextField();
		}
		return queryKeyTextField;
	}

	/**
	 * This method initializes optionTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getOptionTextField() {
		if (optionTextField == null) {
			optionTextField = new JTextField();
		}
		return optionTextField;
	}

	/**
	 * This method initializes encodingTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getEncodingTextField() {
		if (encodingTextField == null) {
			encodingTextField = new JTextField();
		}
		return encodingTextField;
	}

	/**
	 * This method initializes dataFormatComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getDataFormatComboBox() {
		if (dataFormatComboBox == null) {
			dataFormatComboBox = new JComboBox(EndpointSettings.getResultDataTypeList());
		}
		return dataFormatComboBox;
	}

	/**
	 * This method initializes endpointTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getEndpointTextField() {
		if (endpointTextField == null) {
			endpointTextField = new JTextField();
			endpointTextField.setEditable(false);
		}
		return endpointTextField;
	}

	/**
	 * This method initializes queryTypePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getQueryTypePanel() {
		if (queryTypePanel == null) {
			queryTypePanel = new JPanel();
			queryTypePanel.setLayout(new FlowLayout());
			queryTypePanel.add(getQueryTypeDefaultRadioButton(), null);
			queryTypePanel.add(getQueryTypeCustomRadioButton(), null);
			ButtonGroup bg = new ButtonGroup();
			bg.add(getQueryTypeDefaultRadioButton());
			bg.add(getQueryTypeCustomRadioButton());
		}
		return queryTypePanel;
	}

	private void setCustomEnabled(boolean enabled){
		this.getQueryKeyTextField().setEnabled(enabled);
		this.getOptionTextField().setEnabled(enabled);
		this.getEncodingTextField().setEnabled(enabled);
		this.getDataFormatComboBox().setEnabled(enabled);
		this.queryKeyLabel.setEnabled(enabled);
		this.optionLabel.setEnabled(enabled);
		this.encodingLabel.setEnabled(enabled);
		this.resultTypeLabel.setEnabled(enabled);
	}
	
	/**
	 * This method initializes queryTypeDefaultRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getQueryTypeDefaultRadioButton() {
		if (queryTypeDefaultRadioButton == null) {
			queryTypeDefaultRadioButton = new JRadioButton("Default");
			queryTypeDefaultRadioButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setCustomEnabled(false);
				}
			});
		}
		return queryTypeDefaultRadioButton;
	}

	/**
	 * This method initializes queryTypeCustomRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getQueryTypeCustomRadioButton() {
		if (queryTypeCustomRadioButton == null) {
			queryTypeCustomRadioButton = new JRadioButton("Custom");
			queryTypeCustomRadioButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setCustomEnabled(true);
				}
			});
		}
		return queryTypeCustomRadioButton;
	}

	/**
	 * This method initializes namespacesTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getNamespacesTextField() {
		if (namespacesTextField == null) {
			namespacesTextField = new JTextField();
		}
		return namespacesTextField;
	}

	private void setEditEnabled(boolean enabled){
		this.getRepositoryUrlTextField().setEnabled(enabled);
		this.getRepositoryTextField().setEnabled(enabled);
		this.getUserTextField().setEnabled(enabled);
		this.getPassPasswordField().setEnabled(enabled);
		this.urlLabel.setEnabled(enabled);
		this.repositoryLabel.setEnabled(enabled);
		this.userLabel.setEnabled(enabled);
		this.passLabel.setEnabled(enabled);
	}

	/**
	 * This method initializes repositoryTypePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getRepositoryTypePanel() {
		if (repositoryTypePanel == null) {
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.gridx = -1;
			gridBagConstraints4.gridy = -1;
			repositoryTypePanel = new JPanel();
			repositoryTypePanel.setLayout(new FlowLayout());
			repositoryTypePanel.add(getRepositoryOnRadioButton(), gridBagConstraints4);
			repositoryTypePanel.add(getRepositoryOffRadioButton(), new GridBagConstraints());
			ButtonGroup bg = new ButtonGroup();
			bg.add(getRepositoryOnRadioButton());
			bg.add(getRepositoryOffRadioButton());

		}
		return repositoryTypePanel;
	}

	/**
	 * This method initializes repositoryOnRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getRepositoryOnRadioButton() {
		if (repositoryOnRadioButton == null) {
			repositoryOnRadioButton = new JRadioButton();
			repositoryOnRadioButton.setText("ON");
			repositoryOnRadioButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setEditEnabled(true);
				}
			});
		}
		return repositoryOnRadioButton;
	}

	/**
	 * This method initializes repositoryOffRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getRepositoryOffRadioButton() {
		if (repositoryOffRadioButton == null) {
			repositoryOffRadioButton = new JRadioButton();
			repositoryOffRadioButton.setText("OFF");
			repositoryOffRadioButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setEditEnabled(false);
				}
			});
		}
		return repositoryOffRadioButton;
	}

	/**
	 * This method initializes repositoryTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getRepositoryTextField() {
		if (repositoryTextField == null) {
			repositoryTextField = new JTextField();
		}
		return repositoryTextField;
	}

	/**
	 * This method initializes userTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getUserTextField() {
		if (userTextField == null) {
			userTextField = new JTextField();
		}
		return userTextField;
	}

	/**
	 * This method initializes passPasswordField	
	 * 	
	 * @return javax.swing.JPasswordField	
	 */
	private JPasswordField getPassPasswordField() {
		if (passPasswordField == null) {
			passPasswordField = new JPasswordField();
		}
		return passPasswordField;
	}

	/**
	 * This method initializes urlTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getRepositoryUrlTextField() {
		if (repositoryUrlTextField == null) {
			repositoryUrlTextField = new JTextField();
		}
		return repositoryUrlTextField;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
