/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.OWL;

/**
 *
 * @author atsuko
 */

public class QueryPathGenerator {
    private String sparqlEndpoint = null;
    private RDFSchemaAnalyzerFactory factory = null;
    private RDFSchemaAnalyzer analyzer = null;
    //private OWLClassGraph graph;

    /*
    public static void main(String[] args){
        // For Test
        String sp = "http://data.allie.dbcls.jp/sparql";
        String sc = "http://purl.org/allie/ontology/201108#ShortForm";
        String ec = "http://purl.org/allie/ontology/201108#LongForm";
        QueryPathGenerator qpg = new QueryPathGenerator(sp);
        Path[] path = qpg.getPaths(sc, ec, false);
        System.out.println(path.length);
    }*/
    
    public QueryPathGenerator(){
        factory = new RDFSchemaAnalyzerFactory();
    }
    
    public QueryPathGenerator(String sparqlEndpoint){
        factory = new RDFSchemaAnalyzerFactory();
        setSPARQLendpoint(sparqlEndpoint);
    }
    
    public SClass[] getClasses(String keyword){
        String[] keywords = null;
        if ( keyword != null ){ // KOKO
            keywords = new String[1];
            keywords[0] = keyword;            
        }
        try {
            return analyzer.getOWLClasses(null, keywords, sparqlEndpoint, false);
        }catch(Exception e){
            System.err.println(e);
            return null;
        }
    } 
    
    public Path[] getPaths(String startClass, String endClass, boolean countLink){
        if ( analyzer == null ){
            System.err.println("ERROR. SPARQL endpoint is not decided.");
        }
        OWLClassGraph graph = new OWLClassGraph(startClass, endClass);
        return graph.getPaths(analyzer, countLink);
    }
    
    private void setSPARQLendpoint(String sparqlEndpoint){
        this.sparqlEndpoint = sparqlEndpoint;
        setAnalyzer();
    }

    private void setAnalyzer(){
        //analyzer = new EndpointAnalyzer(sparqlEndpoint); //ForTest
        try {
            analyzer = factory.create(sparqlEndpoint);
        } catch (Exception e) {
            System.err.println(e);
        }
    }
}
