package jp.riken.accc.db.rdf.crawler.dataStructure.sparql;

import java.util.ArrayList;

import org.apache.jena.riot.RDFDataMgr;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;

public class JenaModelGenerator {

	String endpointURI = null;
	String[] graphURIs = null;
	Model model = null;
	Dataset dataset = null;
	
	public JenaModelGenerator(String file) throws Exception{
		readCrawlerRdfFile(file);
	}
	
	public void readCrawlerRdfFile(String file) throws Exception{
		model = RDFDataMgr.loadModel(file);
		Property endpointPro = model.getProperty("http://www.w3.org/ns/sparql-service-description#endpoint");
		NodeIterator nit = model.listObjectsOfProperty(endpointPro);
		

		int cnt = 0;
		Resource endPointRes = null;
		while( nit.hasNext() ){
			if( cnt == 0 ){
				RDFNode endPointNode = nit.next();
				endPointRes = endPointNode.asResource();
				endpointURI = endPointRes.getURI();
			}
			cnt++;
		}

		Property hasGraphPro = model.getProperty("http://sparqlbuilder.org/hasGraph");
		NodeIterator nodeit = model.listObjectsOfProperty(endPointRes, hasGraphPro);
		ArrayList<String> graphURIList = new ArrayList<String>(); 
		while( nodeit.hasNext()){
			Resource graphRes = nodeit.nextNode().asResource();
			String graphURI = graphRes.getURI();
			graphURIList.add(graphURI);
		}
		graphURIs = graphURIList.toArray(new String[0]);
	}

	public Model getModel(){
		return model;
	}

	public String getEndpointURI(){
		return endpointURI;
	}

	public String[] getGraphURIs(){
		return graphURIs;
	}

}
